/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.WormholeTeleportEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RegistryHelper;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import net.minecraftforge.eventbus.api.Event;

public class WormholeEntity
extends Entity {
    private int maxAge = 800 + this.f_19796_.m_188503_(1400);
    private int color = this.f_19796_.m_188503_(6);
    private int soundTimer = 0;
    private int yaw = this.f_19796_.m_188503_(360);
    private int pitch = this.f_19796_.m_188503_(20) - 10;

    public WormholeEntity(EntityType<WormholeEntity> type, Level world) {
        super(type, world);
    }

    public WormholeEntity(Level worldIn) {
        this((EntityType<WormholeEntity>)((EntityType)EntityRegistration.WORMHOLE.get()), worldIn);
        this.maxAge = 800 + this.f_19796_.m_188503_(1400);
        this.color = this.f_19796_.m_188503_(6);
        this.yaw = this.f_19796_.m_188503_(360);
        this.pitch = this.f_19796_.m_188503_(20) - 10;
    }

    public WormholeEntity(Level worldIn, int maxAge) {
        this(worldIn);
        this.maxAge = maxAge;
    }

    public WormholeEntity(Level worldIn, double x, double y, double z, int maxAge) {
        this(worldIn, maxAge);
        this.m_6034_(x, y + 7.0, z);
    }

    public WormholeEntity(Level worldIn, double x, double y, double z, int maxAge, int color, int yaw, int pitch) {
        this(worldIn, maxAge);
        this.m_6034_(x, y, z);
        this.color = Math.max(0, Math.min(color, 6));
        this.yaw = yaw;
        this.pitch = pitch;
    }

    protected void m_8097_() {
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_(x, y, z);
        float f = this.m_20205_() / 2.0f;
        float f1 = this.m_20206_();
        this.m_20011_(new AABB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        return true;
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("MaxAge")) {
            this.maxAge = compound.m_128451_("MaxAge");
        }
        if (compound.m_128441_("posX")) {
            this.m_6034_(compound.m_128459_("posX"), compound.m_128459_("posY"), compound.m_128459_("posZ"));
        }
        if (compound.m_128441_("color")) {
            this.color = compound.m_128451_("color");
        }
        if (compound.m_128441_("pitch")) {
            this.pitch = compound.m_128451_("pitch");
        }
        if (compound.m_128441_("yaw")) {
            this.yaw = compound.m_128451_("yaw");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("MaxAge", this.maxAge);
        compound.m_128347_("posX", this.m_20185_());
        compound.m_128347_("posY", this.m_20186_());
        compound.m_128347_("posZ", this.m_20189_());
        compound.m_128405_("color", this.color);
        compound.m_128405_("pitch", this.pitch);
        compound.m_128405_("yaw", this.yaw);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_293725_(int posRotationIncrements, double x, double y, double z, double yaw, double pitch) {
        this.m_6034_(x, y, z);
        this.m_19915_((float)yaw, (float)pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB m_6921_() {
        return IForgeBlockEntity.INFINITE_EXTENT_AABB;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.maxAge != -1 && this.f_19797_ > this.maxAge) {
                this.m_6089_();
            }
        } else if (this.soundTimer <= 0) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistration.ULTRA_WORMHOLE.get(), SoundSource.BLOCKS, 0.3f, 1.0f, false);
            this.soundTimer = 380;
        } else {
            --this.soundTimer;
        }
    }

    public int getColor() {
        return this.color;
    }

    public void m_6123_(Player entityIn) {
        ServerPlayer player;
        entityIn.f_19853_.m_5594_(null, entityIn.m_20183_(), SoundEvents.f_12287_, SoundSource.MASTER, 0.5f, 1.0f);
        if (!this.f_19853_.f_46443_ && this.m_20194_() != null && entityIn instanceof ServerPlayer && !Pixelmon.EVENT_BUS.post((Event)new WormholeTeleportEvent.Pre(player = (ServerPlayer)entityIn, this)) && PixelmonConfigProxy.getDimensions().isUltraSpace()) {
            if (this.f_19853_.m_46472_().equals(UltraSpace.WORLD)) {
                ResourceKey d;
                double z;
                double y;
                double x;
                if (player.getPersistentData().m_128441_("PortalX") && player.getPersistentData().m_128441_("PortalY") && player.getPersistentData().m_128441_("PortalZ") && player.getPersistentData().m_128441_("PortalD")) {
                    x = player.getPersistentData().m_128459_("PortalX");
                    y = player.getPersistentData().m_128459_("PortalY");
                    z = player.getPersistentData().m_128459_("PortalZ");
                    d = RegistryHelper.getKey(Registries.f_256858_, player.getPersistentData().m_128461_("PortalD"));
                } else {
                    x = this.m_20185_();
                    y = this.m_20186_();
                    z = this.m_20189_();
                    d = player.m_8963_();
                }
                double[] destination = new double[]{x, y, z};
                WormholeEntity.wrapIntoWorldBorder(destination, (ResourceKey<Level>)d);
                DimensionHelper.getWorld((ResourceKey<Level>)d).ifPresent(world -> {
                    player.f_19789_ /= 5.0f;
                    BlockPos coords = DimensionHelper.findLocation(world, player, destination[0], this.m_20186_(), destination[2]);
                    player.m_8999_(world, (double)coords.m_123341_(), (double)coords.m_123342_(), (double)coords.m_123343_(), player.f_19857_, player.f_19858_);
                });
            } else {
                if (!PixelmonConfigProxy.getDimensions().isUltraSpace()) {
                    this.m_6074_();
                    return;
                }
                player.m_8127_();
                double[] destination = new double[]{this.m_20185_(), this.m_20186_(), this.m_20189_()};
                WormholeEntity.wrapIntoWorldBorder(destination, UltraSpace.WORLD);
                player.getPersistentData().m_128347_("PortalX", player.m_20185_());
                player.getPersistentData().m_128347_("PortalY", player.m_20186_());
                player.getPersistentData().m_128347_("PortalZ", player.m_20189_());
                player.getPersistentData().m_128359_("PortalD", player.m_9236_().m_46472_().m_135782_().toString());
                DimensionHelper.getWorld(UltraSpace.WORLD).ifPresent(world -> {
                    BlockPos coords = DimensionHelper.findLocation(world, player, destination[0], this.m_20186_(), destination[2]);
                    player.m_8999_(world, (double)coords.m_123341_(), (double)coords.m_123342_(), (double)coords.m_123343_(), player.f_19857_, player.f_19858_);
                });
            }
            WormholeTeleportEvent.Post postEvent = new WormholeTeleportEvent.Post(player, this);
            Pixelmon.EVENT_BUS.post((Event)postEvent);
            if (postEvent.shouldKillPortal()) {
                this.m_6074_();
            }
        }
    }

    public static void wrapIntoWorldBorder(double[] pos, ResourceKey<Level> dimension) {
        Optional<ServerLevel> world = DimensionHelper.getWorld(dimension);
        if (!world.isPresent() || world.get().m_6857_() == null || world.get().m_6857_().m_61937_(new BlockPos((int)pos[0], (int)pos[1], (int)pos[2]))) {
            return;
        }
        WorldBorder border = world.get().m_6857_();
        int w = (int)(border.m_61959_() / 2.0);
        pos[0] = WormholeEntity.wrapOrdinate(pos[0], border.m_6347_() - (double)w, border.m_6347_() + (double)w);
        pos[2] = WormholeEntity.wrapOrdinate(pos[2], border.m_6345_() - (double)w, border.m_6345_() + (double)w);
    }

    private static double wrapOrdinate(double ordinate, double min, double max) {
        if (ordinate > min && ordinate < max) {
            return ordinate;
        }
        if (ordinate == min) {
            return ordinate + 2.0;
        }
        if (ordinate == max) {
            return ordinate - 2.0;
        }
        double dist = ordinate < min ? min - ordinate : ordinate - max;
        int oscillations = (int)Math.floor(dist / (max - min));
        if (ordinate < 0.0) {
            ++oscillations;
        }
        double remainder = dist % (max - min);
        ordinate = oscillations % 2 == 0 ? max - remainder : min + remainder;
        return ordinate;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6097_() {
        return false;
    }

    public int getPitch() {
        return this.pitch;
    }

    public int getYaw() {
        return this.yaw;
    }

    public boolean m_6000_(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }
}

