/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities;

import java.util.ArrayList;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public enum SpawnLocationType {
    LAND(blockPos -> new BlockPos(blockPos.m_123341_(), 255, blockPos.m_123343_()), (world, blockPos) -> {
        BlockPos nextPos = blockPos.m_7495_();
        BlockState state = world.m_8055_(nextPos);
        while (!state.m_280296_() && !state.m_60819_().m_76170_()) {
            nextPos = nextPos.m_7495_();
            state = world.m_8055_(nextPos);
        }
        return nextPos;
    }),
    LAND_NPC(blockPos -> new BlockPos(blockPos.m_123341_(), 255, blockPos.m_123343_()), (world, blockPos) -> {
        BlockPos nextPos = blockPos.m_7495_();
        BlockState state = world.m_8055_(nextPos);
        while (!state.m_280296_() && !state.m_60819_().m_76170_()) {
            nextPos = nextPos.m_7495_();
            state = world.m_8055_(nextPos);
        }
        return nextPos;
    }),
    LAND_VILLAGER(blockPos -> new BlockPos(blockPos.m_123341_(), 255, blockPos.m_123343_()), (world, blockPos) -> {
        BlockPos nextPos = blockPos.m_7495_();
        BlockState state = world.m_8055_(nextPos);
        while (!state.m_280296_() && !state.m_60819_().m_76170_()) {
            nextPos = nextPos.m_7495_();
            state = world.m_8055_(nextPos);
        }
        return nextPos;
    }),
    WATER(blockPos -> new BlockPos(blockPos.m_123341_(), 255, blockPos.m_123343_()), (world, blockPos) -> {
        BlockPos nextPos = blockPos.m_7495_();
        BlockState state = world.m_8055_(nextPos);
        while (!state.m_280296_()) {
            nextPos = nextPos.m_7495_();
            state = world.m_8055_(nextPos);
        }
        return nextPos;
    }),
    UNDERGROUND(blockPos -> new BlockPos(blockPos.m_123341_(), blockPos.m_123342_() + 10, blockPos.m_123343_()), (world, blockPos) -> {
        BlockPos nextPos = blockPos.m_7495_();
        BlockState normalState = world.m_8055_(nextPos);
        BlockState aboveState = world.m_8055_(nextPos.m_7494_());
        while (!normalState.m_280296_() && !normalState.m_60819_().m_76170_() || aboveState.m_280296_()) {
            nextPos = nextPos.m_7495_();
            aboveState = normalState;
            normalState = world.m_8055_(nextPos);
        }
        return nextPos;
    }),
    AIR(blockPos -> blockPos, (world, blockPos) -> {
        BlockState state = world.m_8055_(blockPos);
        while (!state.m_60795_()) {
            blockPos = blockPos.m_7494_();
            state = world.m_8055_(blockPos);
        }
        return blockPos;
    }),
    AIR_PERSISTENT(blockPos -> blockPos, (world, blockPos) -> {
        BlockState state = world.m_8055_(blockPos);
        while (!state.m_60795_()) {
            blockPos = blockPos.m_7494_();
            state = world.m_8055_(blockPos);
        }
        return blockPos;
    }),
    LEGENDARY(blockPos -> blockPos, (world, blockPos) -> blockPos),
    TREE_TOP(blockPos -> blockPos, (world, blockPos) -> blockPos),
    BOSS(blockPos -> blockPos, (world, blockPos) -> blockPos);

    private final Function<BlockPos, BlockPos> spawnStartCalculator;
    private final BiFunction<Level, BlockPos, BlockPos> floorCalculator;

    private SpawnLocationType(Function<BlockPos, BlockPos> spawnStartCalculator, BiFunction<Level, BlockPos, BlockPos> floorCalculator) {
        this.spawnStartCalculator = spawnStartCalculator;
        this.floorCalculator = floorCalculator;
    }

    public BlockPos getSpawnLocation(Level world, BlockPos xy) {
        BlockPos spawnStart = this.spawnStartCalculator.apply(xy);
        return this.floorCalculator.apply(world, spawnStart);
    }

    public static SpawnLocationType[] getSpawnLocations(ArrayList<String> list) {
        SpawnLocationType[] locations = new SpawnLocationType[list.size()];
        int i = 0;
        for (String s : list) {
            for (SpawnLocationType sp : SpawnLocationType.values()) {
                if (!sp.toString().equalsIgnoreCase(s)) continue;
                locations[i++] = sp;
            }
        }
        return locations;
    }

    public static SpawnLocationType getSpawnLocation(String location) {
        for (SpawnLocationType sp : SpawnLocationType.values()) {
            if (!sp.toString().equalsIgnoreCase(location)) continue;
            return sp;
        }
        return null;
    }

    public static SpawnLocationType getFromIndex(int integer) {
        try {
            return SpawnLocationType.values()[integer];
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static SpawnLocationType nextLocation(SpawnLocationType spawnLocation) {
        switch (spawnLocation) {
            case LAND: {
                return WATER;
            }
            case AIR_PERSISTENT: {
                return LAND;
            }
        }
        return SpawnLocationType.getFromIndex((spawnLocation.ordinal() + 1) % SpawnLocationType.values().length);
    }

    public static boolean contains(SpawnLocationType[] locations, SpawnLocationType location) {
        for (SpawnLocationType l : locations) {
            if (l != location) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOnly(SpawnLocationType[] locations, SpawnLocationType location) {
        if (locations.length == 1) {
            return SpawnLocationType.contains(locations, location);
        }
        return false;
    }

    public String getLocalizedName() {
        return I18n.m_118938_((String)("enum.spawnlocation." + this.toString().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
    }
}

