/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.events.raids.DenEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelData;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.registries.PixelmonTicketType;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BiomeHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NBTHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.battles.raids.RaidRandomizer;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.SpawnDenItem;
import java.awt.Color;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DenEntity
extends LivingEntity {
    private static final Rotations DEFAULT_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Color DEFAULT_COLOR_RGBA = new Color(255, 36, 134, 255);
    private static final Color DEFAULT_COLOR_UI_A = new Color(255, 108, 92);
    private static final Color DEFAULT_COLOR_UI_B = new Color(168, 59, 57);
    private static final Color DEFAULT_COLOR_UI_C = new Color(204, 0, 0, 51);
    public static final DataSync<DenEntity, Byte> SYNC_STATUS = new DataSync<DenEntity, Byte>(DenEntity.class, EntityDataSerializers.f_135027_, (denEntity, aByte) -> {
        denEntity.status = aByte;
    });
    public static final DataSync<DenEntity, Color> SYNC_COLOR_RGBA = new DataSync<DenEntity, Color>(DenEntity.class, PixelmonDataSerializers.COLOR, (denEntity, color) -> {
        denEntity.colorRGBA = color;
    });
    public static final DataSync<DenEntity, Color> SYNC_COLOR_UI_A = new DataSync<DenEntity, Color>(DenEntity.class, PixelmonDataSerializers.COLOR, (denEntity, color) -> {
        denEntity.colorUIA = color;
    });
    public static final DataSync<DenEntity, Color> SYNC_COLOR_UI_B = new DataSync<DenEntity, Color>(DenEntity.class, PixelmonDataSerializers.COLOR, (denEntity, color) -> {
        denEntity.colorUIB = color;
    });
    public static final DataSync<DenEntity, Color> SYNC_COLOR_UI_C = new DataSync<DenEntity, Color>(DenEntity.class, PixelmonDataSerializers.COLOR, (denEntity, color) -> {
        denEntity.colorUIC = color;
    });
    public static final DataSync<DenEntity, Boolean> SYNC_DECORATION = new DataSync<DenEntity, Boolean>(DenEntity.class, EntityDataSerializers.f_135035_, (denEntity, aBoolean) -> {
        denEntity.decoration = aBoolean;
    });
    public static final DataSync<DenEntity, Integer> SYNC_BEAMS = new DataSync<DenEntity, Integer>(DenEntity.class, EntityDataSerializers.f_135028_, (denEntity, integer) -> {
        denEntity.beams = integer;
    });
    public static final DataSync<DenEntity, Boolean> SYNC_ANIMATE = new DataSync<DenEntity, Boolean>(DenEntity.class, EntityDataSerializers.f_135035_, (denEntity, aBoolean) -> {
        denEntity.animate = aBoolean;
    });
    public static final DataSync<DenEntity, Boolean> SYNC_HIDE_BASE = new DataSync<DenEntity, Boolean>(DenEntity.class, EntityDataSerializers.f_135035_, (denEntity, aBoolean) -> {
        denEntity.hideBase = aBoolean;
    });
    public static final DataSync<DenEntity, Boolean> SYNC_NO_COLLIDE = new DataSync<DenEntity, Boolean>(DenEntity.class, EntityDataSerializers.f_135035_, (denEntity, aBoolean) -> {
        denEntity.noCollide = aBoolean;
        denEntity.canInteract = aBoolean == false;
    });
    public static final DataSync<DenEntity, Boolean> SYNC_BEAM_ON = new DataSync<DenEntity, Boolean>(DenEntity.class, EntityDataSerializers.f_135035_, (denEntity, aBoolean) -> {
        denEntity.beamOn = aBoolean;
    });
    public static final DataSync<DenEntity, Boolean> SYNC_BEAM_TAPER = new DataSync<DenEntity, Boolean>(DenEntity.class, EntityDataSerializers.f_135035_, (denEntity, aBoolean) -> {
        denEntity.beamTaper = aBoolean;
    });
    public static final DataSync<DenEntity, Float> SYNC_BEAM_LENGTH = new DataSync<DenEntity, Float>(DenEntity.class, EntityDataSerializers.f_135029_, (denEntity, aFloat) -> {
        denEntity.beamLength = aFloat.floatValue();
    });
    public static final DataSync<DenEntity, Float> SYNC_BEAM_WIDTH = new DataSync<DenEntity, Float>(DenEntity.class, EntityDataSerializers.f_135029_, (denEntity, aFloat) -> {
        denEntity.beamWidth = aFloat.floatValue();
    });
    public static final DataSync<DenEntity, Rotations> SYNC_ROTATION = new DataSync<DenEntity, Rotations>(DenEntity.class, EntityDataSerializers.f_135037_, (denEntity, rotations) -> {
        denEntity.rotation = rotations;
    });
    public static final DataSync<DenEntity, RaidData> SYNC_RAID_DATA = new DataSync<DenEntity, RaidData>(DenEntity.class, PixelmonDataSerializers.RAID_DATA, (denEntity, raidData1) -> {
        denEntity.raidData = raidData1;
    });
    public static final DataSync<DenEntity, Integer> SYNC_LAST_ROLL_DAY = new DataSync<DenEntity, Integer>(DenEntity.class, EntityDataSerializers.f_135028_, (denEntity, integer) -> {
        denEntity.lastRollDay = integer;
    });
    private boolean canInteract;
    private byte status;
    private Rotations rotation;
    private boolean decoration;
    private int beams;
    private boolean animate;
    private boolean hideBase;
    private boolean noCollide;
    private boolean beamOn;
    private boolean beamTaper;
    private float beamLength;
    private float beamWidth;
    private Color colorRGBA;
    private Color colorUIA;
    private Color colorUIB;
    private Color colorUIC;
    private RaidData raidData;
    private RaidData inUseRaidData;
    private boolean lockout = false;
    private int lastRollDay = -1;
    private long lastPickTime = -1L;
    private int pickHits = 0;
    public int ticker = 0;
    public PixelmonEntity display = null;
    protected EntityDataSyncManager dataSyncManager;

    public DenEntity(EntityType<DenEntity> type, Level world) {
        super(type, world);
    }

    public DenEntity(Level worldIn) {
        this((EntityType<DenEntity>)((EntityType)EntityRegistration.DEN.get()), worldIn);
        this.setDefaults();
        this.updateBoundingBox();
        this.f_19811_ = true;
    }

    public void setDefaults() {
        this.rotation = DEFAULT_ROTATION;
        this.colorRGBA = DEFAULT_COLOR_RGBA;
        this.colorUIA = DEFAULT_COLOR_UI_A;
        this.colorUIB = DEFAULT_COLOR_UI_B;
        this.colorUIC = DEFAULT_COLOR_UI_C;
        this.decoration = false;
        this.animate = true;
        this.beams = -1;
        this.hideBase = false;
        this.noCollide = false;
        this.beamOn = false;
        this.beamTaper = true;
        this.beamLength = 65.0f;
        this.beamWidth = -1.0f;
        this.f_19794_ = this.m_20068_();
        this.lastRollDay = -1;
    }

    public DenEntity(Level worldIn, double posX, double posY, double posZ) {
        this(worldIn);
        this.m_6034_(posX, posY, posZ);
    }

    protected final void setSize(float width, float height) {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        this.m_6034_(d0, d1, d2);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(SYNC_STATUS, (byte)0);
        this.define(SYNC_RAID_DATA, new RaidData(this.m_19879_(), -1, 1, ""));
        this.define(SYNC_ROTATION, DEFAULT_ROTATION);
        this.define(SYNC_COLOR_RGBA, DEFAULT_COLOR_RGBA);
        this.define(SYNC_COLOR_UI_A, DEFAULT_COLOR_UI_A);
        this.define(SYNC_COLOR_UI_B, DEFAULT_COLOR_UI_B);
        this.define(SYNC_COLOR_UI_C, DEFAULT_COLOR_UI_C);
        this.define(SYNC_DECORATION, false);
        this.define(SYNC_ANIMATE, true);
        this.define(SYNC_BEAMS, -1);
        this.define(SYNC_HIDE_BASE, false);
        this.define(SYNC_NO_COLLIDE, false);
        this.define(SYNC_BEAM_ON, false);
        this.define(SYNC_BEAM_TAPER, true);
        this.define(SYNC_BEAM_LENGTH, Float.valueOf(65.0f));
        this.define(SYNC_BEAM_WIDTH, Float.valueOf(-1.0f));
        this.define(SYNC_LAST_ROLL_DAY, -1);
    }

    protected <A> void define(DataSync<?, A> sync, A value) {
        if (this.dataSyncManager == null) {
            this.dataSyncManager = new EntityDataSyncManager();
        }
        this.dataSyncManager.define((Entity)this, sync, value);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("Status", this.getStatus());
        compound.m_128405_("ColorRGBA", this.colorRGBA.getRGB());
        compound.m_128405_("ColorUIA", this.colorUIA.getRGB());
        compound.m_128405_("ColorUIB", this.colorUIB.getRGB());
        compound.m_128405_("ColorUIC", this.colorUIC.getRGB());
        if (!DEFAULT_ROTATION.equals((Object)this.rotation)) {
            compound.m_128365_("Rotations", (Tag)this.rotation.m_123155_());
        }
        compound.m_128379_("Decoration", this.decoration);
        compound.m_128379_("Animate", this.animate);
        compound.m_128405_("Beams", this.beams);
        compound.m_128379_("HideBase", this.hideBase);
        compound.m_128379_("NoCollide", this.noCollide);
        compound.m_128379_("BeamOn", this.beamOn);
        compound.m_128379_("BeamTaper", this.beamTaper);
        compound.m_128350_("BeamLength", this.beamLength);
        compound.m_128350_("BeamWidth", this.beamWidth);
        compound.m_128405_("LastRollDay", this.lastRollDay);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.setColorRGBA(NBTHelper.getOrDefault(nbt, "ColorRGBA", DEFAULT_COLOR_RGBA.getRGB(), CompoundTag::m_128451_));
        this.setColorUIA(NBTHelper.getOrDefault(nbt, "ColorUIA", DEFAULT_COLOR_UI_A.getRGB(), CompoundTag::m_128451_));
        this.setColorUIB(NBTHelper.getOrDefault(nbt, "ColorUIB", DEFAULT_COLOR_UI_B.getRGB(), CompoundTag::m_128451_));
        this.setColorUIC(NBTHelper.getOrDefault(nbt, "ColorUIC", DEFAULT_COLOR_UI_C.getRGB(), CompoundTag::m_128451_));
        this.f_19794_ = this.m_20068_();
        ListTag nbttaglist = nbt.m_128437_("Rotations", 5);
        this.setRotation(nbttaglist.isEmpty() ? DEFAULT_ROTATION : new Rotations(nbttaglist));
        this.setDecoration(NBTHelper.getOrDefault(nbt, "Decoration", false, CompoundTag::m_128471_));
        this.setAnimate(NBTHelper.getOrDefault(nbt, "Animate", true, CompoundTag::m_128471_));
        this.setBeams(NBTHelper.getOrDefault(nbt, "Beams", -1, CompoundTag::m_128451_));
        this.setBaseHidden(NBTHelper.getOrDefault(nbt, "HideBase", false, CompoundTag::m_128471_));
        this.setNoCollide(NBTHelper.getOrDefault(nbt, "NoCollide", false, CompoundTag::m_128471_));
        this.setBeamOn(NBTHelper.getOrDefault(nbt, "BeamOn", false, CompoundTag::m_128471_));
        this.setBeamTaper(NBTHelper.getOrDefault(nbt, "BeamTaper", false, CompoundTag::m_128471_));
        this.setBeamLength(NBTHelper.getOrDefault(nbt, "BeamLength", Float.valueOf(65.0f), CompoundTag::m_128457_).floatValue());
        this.setBeamWidth(NBTHelper.getOrDefault(nbt, "BeamWidth", Float.valueOf(-1.0f), CompoundTag::m_128457_).floatValue());
        this.setLastRollDay(NBTHelper.getOrDefault(nbt, "LastRollDay", -1, CompoundTag::m_128451_));
    }

    public void m_6478_(MoverType type, Vec3 pos) {
        super.m_6478_(type, pos);
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_6138_() {
        super.m_6138_();
    }

    protected void m_7324_(Entity entityIn) {
        Pixelmon.EVENT_BUS.post((Event)new DenEvent.Collide(this, entityIn));
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (!this.decoration && hand == InteractionHand.MAIN_HAND && player instanceof ServerPlayer && !Pixelmon.EVENT_BUS.post((Event)new DenEvent.Interact(this, player, true))) {
            ServerPlayer playerMP = (ServerPlayer)player;
            PlayerPartyStorage pps = StorageProxy.getPartyNow(playerMP);
            Pokemon pokemon = pps.getFirstAblePokemon();
            if (this.getServerData() != null && this.getServerData().getStars() != -1) {
                if (pokemon != null && pokemon.getPosition() != null) {
                    if (!this.getServerData().addPlayer(4, playerMP, pokemon, pokemon.getPosition().order)) {
                        player.m_213846_((Component)Component.m_237115_((String)"raid.interact.inuse"));
                    }
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"raid.interact.no_party"));
                }
            } else if (this.attemptWishingPiece(player.m_21205_().m_41720_(), player, true)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    private boolean attemptWishingPiece(Item item, Player player, boolean consumeHeldItem) {
        boolean special;
        if (this.getData().isPresent()) {
            return false;
        }
        boolean standard = item == PixelmonItems.wishing_piece;
        boolean bl = special = item == PixelmonItems.waterdude_wishing_piece;
        if (standard || special) {
            Optional<RaidData> raid;
            if (standard) {
                raid = RaidRandomizer.getRandomRaid(this, true);
            } else {
                Predicate<Species> predicate = p -> !p.getFirstForm().hasTag("undexable");
                raid = Optional.of(new RaidData(this.m_19879_(), 5, PixelmonSpecies.getRandomLegendary(predicate)));
            }
            if (raid.isPresent()) {
                this.lockout = true;
                this.setData(raid.get());
                if (player != null) {
                    if (consumeHeldItem && !player.m_7500_()) {
                        player.m_21205_().m_41774_(1);
                    }
                    player.m_213846_((Component)Component.m_237115_((String)"raid.interact.wished"));
                }
                this.f_19853_.m_5594_(null, this.m_20183_(), SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return true;
            }
            if (player != null) {
                player.m_213846_((Component)Component.m_237115_((String)"raid.interact.wishfailed"));
            }
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        block10: {
            if (!(source.m_7640_() instanceof Player) || Pixelmon.EVENT_BUS.post((Event)new DenEvent.Interact(this, (Player)source.m_7640_(), false))) break block10;
            Player player = (Player)source.m_7640_();
            if (!player.m_20193_().f_46443_) {
                ServerLevel world = (ServerLevel)player.m_20193_();
                if (player.m_21205_().m_41720_() == PixelmonItems.den_spawner) {
                    if (SpawnDenItem.isOPOnly && !PlayerHelper.hasPermission((ServerPlayer)player, "pixelmon.denspawner.use")) {
                        return false;
                    }
                    if (!player.m_7500_()) {
                        return false;
                    }
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 0.5f);
                    this.m_6089_();
                    return true;
                }
                if (PixelmonConfigProxy.getRaids().isRaidDensBreakable() && player.m_21205_().m_41720_() instanceof PickaxeItem) {
                    PickaxeItem pick = (PickaxeItem)player.m_21205_().m_41720_();
                    long time = world.m_46467_();
                    if (time - this.lastPickTime > 60L) {
                        this.pickHits = 0;
                    }
                    this.lastPickTime = time;
                    ++this.pickHits;
                    int rank = 7 - pick.m_43314_().m_6604_();
                    if (this.pickHits >= rank) {
                        this.m_6089_();
                        player.m_21205_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                        world.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12313_, SoundSource.BLOCKS, 2.0f, 1.0f);
                        for (int i = 0; i < 100; ++i) {
                            Vec3 sphere = RandomHelper.nextSpherePoint(1.5);
                            world.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), this.m_20185_() + sphere.f_82479_, this.m_20186_() + RandomHelper.getRandom().nextDouble() * 1.5, this.m_20189_() + sphere.f_82481_, 1, RandomHelper.getRandom().nextDouble() - 0.5, RandomHelper.getRandom().nextDouble() - 0.5, RandomHelper.getRandom().nextDouble() - 0.5, RandomHelper.getRandom().nextDouble() * 0.5);
                        }
                    } else {
                        world.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12446_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        for (int i = 0; i < 10 * this.pickHits; ++i) {
                            Vec3 sphere = RandomHelper.nextSpherePoint(1.5);
                            world.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), this.m_20185_() + sphere.f_82479_, this.m_20186_() + RandomHelper.getRandom().nextDouble() * 1.5, this.m_20189_() + sphere.f_82481_, 1, RandomHelper.getRandom().nextDouble() - 0.5, RandomHelper.getRandom().nextDouble() - 0.5, RandomHelper.getRandom().nextDouble() - 0.5, RandomHelper.getRandom().nextDouble() * 0.5);
                        }
                    }
                }
            }
        }
        return false;
    }

    public void setStatus(byte status) {
        SYNC_STATUS.set((Entity)this, (Object)status);
    }

    public byte getStatus() {
        return this.status;
    }

    public void setData(RaidData data) {
        this.raidData = data;
        SYNC_RAID_DATA.set((Entity)this, (Object)data);
    }

    public void setInUseRaidData() {
        this.inUseRaidData = this.raidData;
    }

    public RaidData getInUseRaidData() {
        return this.inUseRaidData;
    }

    public void clearData() {
        SYNC_RAID_DATA.set((Entity)this, (Object)new RaidData(this.m_19879_(), -1, 1, ""));
    }

    public RaidData getServerData() {
        return this.raidData;
    }

    public Optional<RaidData> getData() {
        if (this.raidData.getStars() < 0) {
            return Optional.empty();
        }
        return Optional.of(this.raidData);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6000_(double x, double y, double z) {
        this.f_19811_ = true;
        return true;
    }

    protected float m_5632_(float p_110146_1_, float p_110146_2_) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.f_19857_;
        return 0.0f;
    }

    public double getMyRidingOffset() {
        return 0.1f;
    }

    public void m_5618_(float offset) {
        this.f_20884_ = this.f_19859_ = offset;
        this.f_20886_ = this.f_20885_ = offset;
    }

    public HumanoidArm m_5737_() {
        return null;
    }

    public void m_5616_(float rotation) {
        this.f_20884_ = this.f_19859_ = rotation;
        this.f_20886_ = this.f_20885_ = rotation;
    }

    public boolean m_7313_(Entity entityIn) {
        return false;
    }

    public boolean m_7337_(Entity entity) {
        if (entity.m_6095_().equals(EntityType.f_20461_) && entity.m_20194_() != null) {
            ItemEntity itemEntity = (ItemEntity)entity;
            Player player = (Player)itemEntity.m_19749_();
            if (this.attemptWishingPiece(itemEntity.m_32055_().m_41720_(), player, false)) {
                itemEntity.m_32055_().m_41774_(1);
            }
            return false;
        }
        return super.m_7337_(entity);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20077_()) {
            EntityHelper.setMotion((Entity)this, EnumRotation.y, 0.0);
        }
        if (this.f_19853_ instanceof ServerLevel) {
            if (!this.decoration) {
                long now = this.f_19853_.m_46468_();
                int day = (int)(now / 24000L);
                long marker = (long)(this.lastRollDay + 1) * 24000L;
                if (this.lastRollDay > day + 1) {
                    this.lastRollDay = 0;
                }
                if (day != this.lastRollDay && (this.f_19853_.m_46468_() % 24000L == (long)PixelmonConfigProxy.getRaids().getDenRespawnTime() || now >= marker)) {
                    this.roll(day);
                }
            }
        } else {
            this.getDisplay().ifPresent(display -> {
                for (ModelData modelData : display.getModel()) {
                    display.getAnimationVariables(modelData).tick();
                }
            });
        }
        if (this.getServerData() != null) {
            this.getServerData().onUpdate(this);
        }
    }

    public void roll(int day) {
        this.setLastRollDay(day);
        if (this.getData().isPresent()) {
            if (!this.getServerData().hasPlayers()) {
                this.clearData();
            }
        } else if (this.lockout) {
            this.lockout = false;
        } else {
            RaidRandomizer.getRandomRaid(this, false).ifPresent(raid -> {
                ChunkPos chunkPos = new ChunkPos(this.m_20183_().m_123341_() >> 4, this.m_20183_().m_123343_() >> 4);
                ((ServerLevel)this.f_19853_).m_7726_().m_8387_(PixelmonTicketType.RAID_DEN, chunkPos, 1, (Object)this.m_19879_());
                this.setData((RaidData)raid);
                this.announce(this, raid.getSpecies(), (Holder<Biome>)this.f_19853_.m_204166_(this.m_20183_()));
            });
        }
    }

    private void announce(DenEntity den, Species species, Holder<Biome> biome) {
        if (PixelmonConfigProxy.getSpawning().isDoLegendaryRaidEvent() && species.getDefaultForm().getTags().isLegendary()) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            String localizedBiome = BiomeHelper.getLocalizedBiomeName(biome).getString();
            Component message = TextHelper.translate(ChatFormatting.GREEN, "spawn.legendaryraidmessage", species.getLocalizedName(), localizedBiome);
            server.m_6846_().m_240416_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ChatFormatting.LIGHT_PURPLE + "Pixelmon" + ChatFormatting.RESET, message}), true);
            BlockPos pos = den.m_20183_();
            server.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.LIGHT_PURPLE + "Spawned " + species.getName() + " at: " + den.f_19853_.m_46472_().m_135782_() + " x:" + pos.m_123341_() + ", y:" + pos.m_123342_() + ", z:" + pos.m_123343_())));
        }
    }

    private void updateBoundingBox() {
        this.setSize(2.25f, 0.5f);
    }

    protected void m_8034_() {
        this.m_6842_(this.canInteract);
    }

    public void m_6842_(boolean invisible) {
        this.canInteract = invisible;
        super.m_6842_(invisible);
    }

    public void m_6074_() {
        this.m_6089_();
    }

    public boolean m_6128_() {
        return true;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public boolean m_6063_() {
        return false;
    }

    public void setColorRGBA(int rgb) {
        SYNC_COLOR_RGBA.set((Entity)this, (Object)new Color(rgb));
    }

    public Color getColorRGBA() {
        return this.colorRGBA;
    }

    public void setColorUIA(int rgb) {
        SYNC_COLOR_UI_A.set((Entity)this, (Object)new Color(rgb));
    }

    public Color getColorUIA() {
        return this.colorUIA;
    }

    public void setColorUIB(int rgb) {
        SYNC_COLOR_UI_B.set((Entity)this, (Object)new Color(rgb));
    }

    public Color getColorUIB() {
        return this.colorUIB;
    }

    public void setColorUIC(int rgb) {
        SYNC_COLOR_UI_C.set((Entity)this, (Object)new Color(rgb));
    }

    public Color getColorUIC() {
        return this.colorUIC;
    }

    public void setDecoration(boolean decoration) {
        SYNC_DECORATION.set((Entity)this, (Object)decoration);
    }

    public boolean isDecoration() {
        return this.decoration;
    }

    public void setAnimate(boolean animate) {
        SYNC_ANIMATE.set((Entity)this, (Object)animate);
    }

    public boolean isAnimating() {
        return this.animate;
    }

    public void setBeams(int beams) {
        SYNC_BEAMS.set((Entity)this, (Object)beams);
    }

    public int getBeams() {
        return this.beams;
    }

    public void setBaseHidden(boolean hideBase) {
        SYNC_HIDE_BASE.set((Entity)this, (Object)hideBase);
    }

    public boolean isBaseHidden() {
        return this.hideBase;
    }

    public void setNoCollide(boolean noCollide) {
        SYNC_NO_COLLIDE.set((Entity)this, (Object)noCollide);
    }

    public boolean isNoCollide() {
        boolean noCollide = this.noCollide;
        this.canInteract = !noCollide;
        return noCollide;
    }

    public void setBeamOn(boolean beamOn) {
        SYNC_BEAM_ON.set((Entity)this, (Object)beamOn);
    }

    public boolean isBeamOn() {
        return this.beamOn;
    }

    public void setBeamTaper(boolean beamTaper) {
        SYNC_BEAM_TAPER.set((Entity)this, (Object)beamTaper);
    }

    public boolean isBeamTaper() {
        return this.beamTaper;
    }

    public void setBeamLength(float beamLength) {
        SYNC_BEAM_LENGTH.set((Entity)this, (Object)Float.valueOf(beamLength));
    }

    public float getBeamLength() {
        return this.beamLength;
    }

    public void setBeamWidth(float beamWidth) {
        SYNC_BEAM_WIDTH.set((Entity)this, (Object)Float.valueOf(beamWidth));
    }

    public float getBeamWidth() {
        return this.beamWidth;
    }

    public void setLastRollDay(int lastRollDay) {
        SYNC_LAST_ROLL_DAY.set((Entity)this, (Object)lastRollDay);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<PixelmonEntity> getDisplay() {
        Optional<RaidData> raid = this.getData();
        if (raid.isPresent()) {
            if (this.display == null) {
                Pokemon pokemon = PokemonFactory.create(raid.get().getSpecies());
                if (raid.get().getForm() != null) {
                    pokemon.setForm(raid.get().getForm());
                }
                pokemon.setGrowth(EnumGrowth.Ordinary);
                this.display = new PixelmonEntity(this.f_19853_, pokemon);
                this.display.setAnimation(AnimationType.IDLE);
                this.display.checkAnimation();
                this.display.initAnimation();
            }
            if (this.display != null && (!this.display.getPokemon().getSpecies().is(raid.get().getSpecies()) || raid.get().getForm() != null && !this.display.getForm().getName().equalsIgnoreCase(raid.get().getForm().getName()))) {
                this.display = null;
            }
            return Optional.ofNullable(this.display);
        }
        return Optional.empty();
    }

    private byte setBit(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public void setRotation(Rotations vec) {
        SYNC_ROTATION.set((Entity)this, (Object)vec);
    }

    public Rotations getRotation() {
        return this.rotation;
    }

    public boolean m_6087_() {
        return true;
    }

    public SoundEvent m_5896_(int heightIn) {
        return SoundEvents.f_12445_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12446_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12442_;
    }

    protected float m_6121_() {
        return 0.0f;
    }

    public boolean m_5801_() {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }

    public boolean m_5789_() {
        return false;
    }

    public AABB m_6921_() {
        return IForgeBlockEntity.INFINITE_EXTENT_AABB;
    }

    @Nullable
    public AABB getCollisionBoundingBox() {
        if (this.f_19853_.f_46443_) {
            return this.m_6084_() && !this.isNoCollide() ? this.m_20191_() : null;
        }
        return this.m_6084_() && !this.noCollide ? this.m_20191_() : null;
    }

    public boolean m_5829_() {
        return this.m_6084_() && !this.noCollide;
    }

    public boolean m_6060_() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6051_() {
        return false;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PixelmonItems.den_spawner);
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
    }

    public boolean m_6040_() {
        return true;
    }
}

