/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.dev;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DevTools {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void init() {
        DevTools.generateVerificationJSON();
    }

    private static void generateVerificationJSON() {
        JsonObject jsonObject = new JsonObject();
        JsonArray biomeTags = new JsonArray();
        JsonArray blocks = new JsonArray();
        JsonArray items = new JsonArray();
        ServerLifecycleHooks.getCurrentServer().m_206579_().m_203557_().m_206193_().forEach(key -> {
            if (key.f_206233_() == Registries.f_256952_) {
                key.f_206234_().m_203612_().forEach(tag -> biomeTags.add("#" + ((TagKey)tag.getFirst()).f_203868_()));
                key.f_206234_().m_6566_().forEach(biome -> biomeTags.add(biome.toString()));
            }
            if (key.f_206233_() == Registries.f_256747_) {
                key.f_206234_().m_203612_().forEach(tag -> blocks.add("#" + ((TagKey)tag.getFirst()).f_203868_().toString()));
                key.f_206234_().m_6566_().forEach(block -> blocks.add(block.toString()));
            }
            if (key.f_206233_() == Registries.f_256913_) {
                key.f_206234_().m_203612_().forEach(tag -> items.add("#" + ((TagKey)tag.getFirst()).f_203868_().toString()));
                key.f_206234_().m_6566_().forEach(item -> items.add(item.toString()));
            }
        });
        jsonObject.add("biomes", (JsonElement)biomeTags);
        jsonObject.add("blocks", (JsonElement)blocks);
        jsonObject.add("items", (JsonElement)items);
        try {
            FileWriter fileWriter = new FileWriter("verification.json");
            fileWriter.write(GSON.toJson((JsonElement)jsonObject));
            fileWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

