/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config.starter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import net.minecraft.network.FriendlyByteBuf;

public class StarterOption {
    private final String labelOn;
    private final String labelOff;
    private final int width;
    private final int x;
    private final int y;
    private final PokemonSpecification spec;

    public StarterOption(JsonObject json, JsonDeserializationContext ctx) {
        this.labelOn = json.get("labelOn").getAsString();
        this.labelOff = json.get("labelOff").getAsString();
        this.width = json.get("width").getAsInt();
        this.x = json.get("x").getAsInt();
        this.y = json.get("y").getAsInt();
        this.spec = (PokemonSpecification)ctx.deserialize(json.get("spec"), PokemonSpecification.class);
    }

    public StarterOption(FriendlyByteBuf buf) {
        this.labelOn = buf.m_130277_();
        this.labelOff = buf.m_130277_();
        this.width = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.spec = PokemonSpecificationProxy.create(buf.m_130277_()).get();
    }

    public JsonObject toJson(JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        json.addProperty("labelOn", this.labelOn);
        json.addProperty("labelOff", this.labelOff);
        json.addProperty("width", (Number)this.width);
        json.addProperty("x", (Number)this.x);
        json.addProperty("y", (Number)this.y);
        json.add("spec", ctx.serialize((Object)this.spec));
        return json;
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.m_130070_(this.labelOn);
        buf.m_130070_(this.labelOff);
        buf.writeInt(this.width);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.m_130070_(this.spec.toString());
    }

    public String getLabel(boolean on) {
        return on ? this.labelOn : this.labelOff;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public PokemonSpecification getSpec() {
        return this.spec;
    }
}

