/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config.starter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.api.SpecificationTypeAdapter;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.TickHandler;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.config.starter.ColorTypeAdapter;
import com.pixelmonmod.pixelmon.config.starter.Starter;
import com.pixelmonmod.pixelmon.config.starter.StarterOption;
import com.pixelmonmod.pixelmon.config.starter.StarterOptionTypeAdapter;
import com.pixelmonmod.pixelmon.config.starter.StarterTypeAdapter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraftforge.eventbus.api.Event;

public class StarterList {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).registerTypeAdapter(PokemonSpecification.class, new SpecificationTypeAdapter(PokemonSpecification.class)).registerTypeAdapter(Starter.class, (Object)new StarterTypeAdapter()).registerTypeAdapter(StarterOption.class, (Object)new StarterOptionTypeAdapter()).serializeNulls().create();
    private static final List<Starter> STARTERS = Lists.newArrayList();
    private static final List<Tuple<PokemonSpecification, Integer>> CHANCE_SPECS = Lists.newCopyOnWriteArrayList();
    private static final List<StarterOption> OPTIONS = Lists.newCopyOnWriteArrayList();
    private static final Map<Integer, Color> PAGE_COLORS = Maps.newHashMap();
    private static boolean LOOP = false;
    private static final String[] TEXT = new String[]{"", ""};
    private static final transient Color DEFAULT_COLOR = new Color(0, 0, 255, 255);

    public static List<Starter> getStarters() {
        return STARTERS;
    }

    public static List<StarterOption> getOptions() {
        return OPTIONS;
    }

    public static Color getColor(int page) {
        return PAGE_COLORS.getOrDefault(page, DEFAULT_COLOR);
    }

    public static boolean shouldLoop() {
        return LOOP;
    }

    public static String[] getText() {
        return TEXT;
    }

    public static List<PokemonSpecification> getExtraSpecs(boolean[] options) {
        ArrayList specs = Lists.newArrayList();
        for (int i = 0; i < OPTIONS.size(); ++i) {
            if (!options[i]) continue;
            specs.add(OPTIONS.get(i).getSpec());
        }
        return specs;
    }

    public static boolean pick(ServerPlayer player, int index, boolean[] options) {
        PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
        if (storage.starterPicked) {
            return false;
        }
        if (index < 0 || index >= STARTERS.size()) {
            return false;
        }
        if (options.length != OPTIONS.size()) {
            return false;
        }
        Starter starter = STARTERS.get(index);
        ArrayList specs = Lists.newArrayList();
        for (Tuple<PokemonSpecification, Integer> spec : CHANCE_SPECS) {
            if ((Integer)spec.m_14419_() != 1 && !RandomHelper.getRandomChance((float)(1 / (Integer)spec.m_14419_()))) continue;
            specs.add((PokemonSpecification)spec.m_14418_());
        }
        for (int i = 0; i < OPTIONS.size(); ++i) {
            if (!options[i]) continue;
            specs.add(OPTIONS.get(i).getSpec());
        }
        Pokemon pokemon = starter.createPokemon(specs);
        storage.starterPicked = true;
        if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent(player, pokemon, "Starter"))) {
            return false;
        }
        storage.add(pokemon);
        TickHandler.deregisterStarterList(player);
        return true;
    }

    private static void reset() {
        STARTERS.clear();
        CHANCE_SPECS.clear();
        OPTIONS.clear();
        PAGE_COLORS.clear();
        LOOP = false;
        StarterList.TEXT[0] = "";
        StarterList.TEXT[1] = "";
    }

    public static void readFromJson(Gson gson, JsonElement json) {
        StarterList.reset();
        JsonObject object = json.getAsJsonObject();
        for (JsonElement starter : object.getAsJsonArray("starters")) {
            STARTERS.add((Starter)gson.fromJson(starter, Starter.class));
        }
        for (JsonElement element : object.getAsJsonArray("chanceSpecs")) {
            JsonObject object2 = element.getAsJsonObject();
            PokemonSpecification spec = (PokemonSpecification)gson.fromJson(object2.get("spec"), PokemonSpecification.class);
            int rate = object2.getAsJsonPrimitive("rate").getAsInt();
            CHANCE_SPECS.add((Tuple<PokemonSpecification, Integer>)new Tuple((Object)spec, (Object)rate));
        }
        for (JsonElement option : object.getAsJsonArray("options")) {
            OPTIONS.add((StarterOption)gson.fromJson(option, StarterOption.class));
        }
        for (JsonElement pageColor : object.getAsJsonArray("pageColors")) {
            JsonObject pageColorObj = pageColor.getAsJsonObject();
            int page = pageColorObj.get("page").getAsInt();
            JsonObject color = pageColorObj.getAsJsonObject("color");
            PAGE_COLORS.put(page, new Color(color.get("r").getAsInt(), color.get("g").getAsInt(), color.get("b").getAsInt(), color.get("a").getAsInt()));
        }
        LOOP = object.get("loop").getAsBoolean();
        JsonArray text = object.getAsJsonArray("text");
        if (text.size() > 0) {
            StarterList.TEXT[0] = text.get(0).getAsString();
            if (text.size() > 1) {
                StarterList.TEXT[1] = text.get(1).getAsString();
            }
        }
    }

    public static void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeInt(STARTERS.size());
        for (Starter starter : STARTERS) {
            starter.toBuffer(buf);
        }
        buf.writeInt(OPTIONS.size());
        for (StarterOption starterOption : OPTIONS) {
            starterOption.toBuffer(buf);
        }
        buf.writeInt(PAGE_COLORS.size());
        for (Map.Entry entry : PAGE_COLORS.entrySet()) {
            buf.writeInt(((Integer)entry.getKey()).intValue());
            buf.writeInt(((Color)entry.getValue()).getRed());
            buf.writeInt(((Color)entry.getValue()).getGreen());
            buf.writeInt(((Color)entry.getValue()).getBlue());
            buf.writeInt(((Color)entry.getValue()).getAlpha());
        }
        buf.writeInt(CHANCE_SPECS.size());
        for (Tuple tuple : CHANCE_SPECS) {
            buf.m_130070_(((PokemonSpecification)tuple.m_14418_()).toString());
            buf.writeInt(((Integer)tuple.m_14419_()).intValue());
        }
        buf.writeBoolean(LOOP);
        buf.m_130070_(TEXT[0]);
        buf.m_130070_(TEXT[1]);
    }

    public static void readFromBuffer(FriendlyByteBuf buf) {
        StarterList.reset();
        int starterSize = buf.readInt();
        for (int i = 0; i < starterSize; ++i) {
            STARTERS.add(new Starter(buf));
        }
        int optionSize = buf.readInt();
        for (int i = 0; i < optionSize; ++i) {
            OPTIONS.add(new StarterOption(buf));
        }
        int pageColorSize = buf.readInt();
        for (int i = 0; i < pageColorSize; ++i) {
            PAGE_COLORS.put(buf.readInt(), new Color(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt()));
        }
        int chances = buf.readInt();
        for (int i = 0; i < chances; ++i) {
            PokemonSpecification specification = PokemonSpecificationProxy.create(buf.m_130277_()).get();
            int chance = buf.readInt();
            CHANCE_SPECS.add((Tuple<PokemonSpecification, Integer>)new Tuple((Object)specification, (Object)chance));
        }
        LOOP = buf.readBoolean();
        StarterList.TEXT[0] = buf.m_130277_();
        StarterList.TEXT[1] = buf.m_130277_();
    }
}

