/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config.starter;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.config.starter.StarterList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;

public class Starter {
    private final PokemonSpecification spec;
    private final List<Tuple<PokemonSpecification, Integer>> chanceSpecs;
    private final int page;
    private final int x;
    private final int y;
    private final int scale;
    private transient Pokemon display = null;

    public Starter(JsonObject json, JsonDeserializationContext ctx) {
        this.spec = (PokemonSpecification)ctx.deserialize(json.get("spec"), PokemonSpecification.class);
        this.chanceSpecs = Lists.newArrayList();
        for (JsonElement element : json.getAsJsonArray("chanceSpecs")) {
            JsonObject object = element.getAsJsonObject();
            PokemonSpecification spec = (PokemonSpecification)ctx.deserialize(object.get("spec"), PokemonSpecification.class);
            int rate = object.getAsJsonPrimitive("rate").getAsInt();
            this.chanceSpecs.add((Tuple<PokemonSpecification, Integer>)new Tuple((Object)spec, (Object)rate));
        }
        this.page = json.get("page").getAsInt();
        this.x = json.get("x").getAsInt();
        this.y = json.get("y").getAsInt();
        this.scale = json.get("scale").getAsInt();
    }

    public Starter(FriendlyByteBuf buf) {
        this.spec = PokemonSpecificationProxy.create(buf.m_130277_()).get();
        this.chanceSpecs = Lists.newArrayList();
        this.page = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.scale = buf.readInt();
    }

    public JsonObject toJson(JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        json.add("spec", ctx.serialize((Object)this.spec));
        JsonArray array = new JsonArray();
        for (Tuple<PokemonSpecification, Integer> spec : this.chanceSpecs) {
            JsonObject object = new JsonObject();
            object.add("spec", ctx.serialize(spec.m_14418_()));
            object.addProperty("chance", (Number)spec.m_14419_());
            array.add((JsonElement)object);
        }
        json.add("chanceSpecs", (JsonElement)array);
        json.addProperty("page", (Number)this.page);
        json.addProperty("x", (Number)this.x);
        json.addProperty("y", (Number)this.y);
        json.addProperty("scale", (Number)this.scale);
        return json;
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.m_130070_(this.spec.toString());
        buf.writeInt(this.page);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.scale);
    }

    public Pokemon createPokemon(List<PokemonSpecification> extraSpecs) {
        StringBuilder specBuilder = new StringBuilder(this.spec.toString());
        for (Tuple<PokemonSpecification, Integer> tuple : this.chanceSpecs) {
            if (!RandomHelper.getRandomChance(1 / (Integer)tuple.m_14419_())) continue;
            specBuilder.append(" ").append(tuple.m_14418_());
        }
        for (PokemonSpecification pokemonSpecification : extraSpecs) {
            specBuilder.append(" ").append(pokemonSpecification);
        }
        return PokemonSpecificationProxy.create(specBuilder.toString()).get().create();
    }

    public Pokemon getDisplay(boolean[] options) {
        if (this.display == null) {
            this.display = this.spec.create();
            for (PokemonSpecification spec : StarterList.getExtraSpecs(options)) {
                spec.apply(this.display);
            }
        }
        return this.display;
    }

    public void resetDisplay() {
        this.display = null;
    }

    public int getPage() {
        return this.page;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getScale() {
        return this.scale;
    }
}

