/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategyLoader;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class WikiCommand
extends PixelCommand {
    public WikiCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "wiki", "/wiki <slot | specs...>", 0);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        Pokemon pokemon;
        if (args.length == 0) {
            sender.m_288197_(() -> PixelmonCommandUtils.format("pixelmon.command.wiki.usage.one", new Object[0]).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.usage.two", new Object[0]).m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"pixelmon.command.wiki.banner.hover"))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://pixelmonmod.com/wiki/"))).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.usage.three", new Object[0])).m_130946_("\n").m_130946_(this.getUsage(sender))), true);
            return;
        }
        if (PixelmonCommandUtils.PARTY_SLOTS.contains(args[0])) {
            ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(sender);
            PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
            int slot = PixelmonCommandUtils.requireInt(args[0], 1, 6, "pixelmon.command.pokeedit.slot", new Object[0]);
            pokemon = PixelmonCommandUtils.require(storage.get(slot - 1), "pixelmon.command.partyslot.nothing", player.m_7755_());
        } else {
            pokemon = PokemonSpecificationProxy.create(args).get().create();
            if (pokemon.getSpecies().is(PixelmonSpecies.MISSINGNO)) {
                sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
                PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
            }
        }
        sender.m_288197_(() -> Component.m_237119_(), false);
        String strategyId = args[args.length - 1];
        WikiCommandStrategyLoader.executeStrategy(sender, pokemon, args, strategyId);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length >= 1) {
            List<String> suggestions = PixelmonCommandUtils.SPEC_REQUIREMENTS;
            suggestions.addAll(PixelmonSpecies.getFormattedEnglishNameSet());
            suggestions.addAll(PixelmonCommandUtils.PARTY_SLOTS);
            return suggestions;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

