/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.PokemonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SpawningStrategy
extends WikiCommandStrategy {
    public SpawningStrategy() {
        super("spawning");
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public void execute(CommandSourceStack sender, Pokemon pokemon, String[] args) {
        List<SpawnInfoPokemon> standardSpawnInfos;
        sender.m_288197_(() -> PixelmonCommandUtils.format("pixelmon.command.wiki.spawning.header", PokemonHelper.getFullName(pokemon).m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})), false);
        Map<String, List<SpawnSet>> spawnSets = PixelmonSpawning.getAll();
        ArrayList standard = Lists.newArrayList();
        if (spawnSets.containsKey("standard")) {
            standard.addAll((Collection)spawnSets.remove("standard"));
        }
        if (spawnSets.containsKey("legendaries")) {
            standard.addAll((Collection)spawnSets.remove("legendaries"));
        }
        if (!(standardSpawnInfos = SpawningStrategy.getSpawnInfo(pokemon, standard)).isEmpty()) {
            SpawningStrategy.sendBiomeMessage(sender, standardSpawnInfos, "standard");
        }
        boolean anyBiome = false;
        for (Map.Entry<String, List<SpawnSet>> entry : spawnSets.entrySet()) {
            List<SpawnInfoPokemon> spawnInfos;
            if (entry.getKey().equalsIgnoreCase("npc") || entry.getKey().equalsIgnoreCase("megas") || (spawnInfos = SpawningStrategy.getSpawnInfo(pokemon, entry.getValue())).isEmpty()) continue;
            anyBiome = true;
            sender.m_288197_(() -> Component.m_237113_((String)""), false);
            SpawningStrategy.sendBiomeMessage(sender, spawnInfos, entry.getKey());
        }
        if (standardSpawnInfos.isEmpty() && !anyBiome) {
            sender.m_288197_(() -> PixelmonCommandUtils.format("pixelmon.command.wiki.spawning.nobiome", new Object[0]), false);
        }
    }

    private static void sendBiomeMessage(CommandSourceStack sender, List<SpawnInfoPokemon> spawnInfos, String name) {
        sender.m_288197_(() -> PixelmonCommandUtils.format("pixelmon.command.wiki.spawning." + name, new Object[0]), false);
        for (SpawnInfoPokemon spawnInfo : spawnInfos) {
            String biomes = spawnInfo.condition.biomes.stream().map(biome -> biome.toString()).collect(Collectors.joining(", "));
            sender.m_288197_(() -> TextHelper.space(1).m_7220_((Component)Component.m_237115_((String)"pixelmon.command.wiki.spawning.spec")).m_7220_((Component)Component.m_237113_((String)spawnInfo.getPokemonSpec().toString())), false);
            if (biomes.isEmpty()) {
                sender.m_288197_(() -> PixelmonCommandUtils.format("pixelmon.command.wiki.spawning.nospawnsinbiome", new Object[0]), false);
            } else {
                sender.m_288197_(() -> TextHelper.space(1).m_7220_((Component)Component.m_237115_((String)"pixelmon.command.wiki.spawning.biomes")).m_7220_((Component)PixelmonCommandUtils.format(biomes, new Object[0])), false);
            }
            sender.m_288197_(() -> TextHelper.space(2).m_7220_((Component)SpawningStrategy.getRarityFormatted(spawnInfo.rarity)), false);
            if (spawnInfo.condition.cachedWeathers != null && !spawnInfo.condition.cachedWeathers.isEmpty()) {
                sender.m_288197_(() -> TextHelper.space(2).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.spawning.weather", spawnInfo.condition.cachedWeathers.stream().map(WeatherType::getLocalizedName).collect(Collectors.joining(", ")))), false);
            }
            if (spawnInfo.condition.times == null || spawnInfo.condition.times.isEmpty()) continue;
            sender.m_288197_(() -> TextHelper.space(2).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.spawning.time", spawnInfo.condition.times.stream().map(ITranslatable::getLocalizedName).collect(Collectors.joining(", ")))), false);
        }
    }

    private static List<SpawnInfoPokemon> getSpawnInfo(Pokemon pokemon, List<SpawnSet> spawnSets) {
        ArrayList spawnInfos = Lists.newArrayList();
        for (SpawnSet spawnSet : spawnSets) {
            for (SpawnInfo spawnInfo : spawnSet.spawnInfos) {
                SpawnInfoPokemon spawnInfoPokemon;
                if (!(spawnInfo instanceof SpawnInfoPokemon) || (spawnInfoPokemon = (SpawnInfoPokemon)spawnInfo).getSpecies() == null || spawnInfoPokemon.getSpecies().getDex() != pokemon.getSpecies().getDex()) continue;
                spawnInfos.add(spawnInfoPokemon);
            }
        }
        return spawnInfos;
    }

    private static MutableComponent getRarityFormatted(float rarity) {
        Object rarityKey = "pixelmon.command.wiki.spawning.rarity.";
        rarityKey = (double)rarity <= 10.0 ? (String)rarityKey + "ultra_rare" : ((double)rarity <= 25.0 ? (String)rarityKey + "very_rare" : ((double)rarity <= 50.0 ? (String)rarityKey + "rare" : ((double)rarity <= 200.0 ? (String)rarityKey + "uncommon" : (String)rarityKey + "common")));
        return PixelmonCommandUtils.format("pixelmon.command.wiki.spawning.rarity", new Object[0]).m_7220_((Component)TextHelper.space(1)).m_7220_((Component)PixelmonCommandUtils.format((String)rarityKey, new Object[0]));
    }
}

