/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.PokemonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MovesStrategy
extends WikiCommandStrategy {
    public MovesStrategy() {
        super("moves");
    }

    @Override
    public int getPriority() {
        return 70;
    }

    @Override
    public void execute(CommandSourceStack sender, Pokemon pokemon, String[] args) {
        Set<ImmutableAttack> tmMoves;
        Set<ImmutableAttack> eggMoves;
        MutableComponent text;
        sender.m_288197_(() -> Component.m_237113_((String)""), false);
        sender.m_288197_(() -> PixelmonCommandUtils.format("pixelmon.command.wiki.moves.header", PokemonHelper.getFullName(pokemon).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GREEN, ChatFormatting.BOLD})), false);
        Map<Integer, Set<ImmutableAttack>> levelUpMoves = pokemon.getForm().getMoves().getPokemonLevelUpMoves();
        if (!levelUpMoves.isEmpty()) {
            sender.m_288197_(() -> TextHelper.space(2).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.moves.leveltm.header", new Object[0])), false);
            for (Map.Entry entry : levelUpMoves.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())) {
                text = TextHelper.space(4).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.moves.leveltm.lvl", new Object[0])).m_7220_((Component)Component.m_237113_((String)(" " + entry.getKey() + ": "))).m_130946_(((Set)entry.getValue()).stream().map(ITranslatable::getLocalizedName).collect(Collectors.joining(", "))).m_130940_(ChatFormatting.GRAY);
                sender.m_288197_(() -> text, false);
            }
        }
        if (!(eggMoves = pokemon.getForm().getMoves().getEggMoves()).isEmpty()) {
            sender.m_288197_(() -> TextHelper.space(2).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.moves.eggmoves.header", new Object[0])), false);
            MutableComponent text2 = TextHelper.space(4).m_130946_(eggMoves.stream().map(ITranslatable::getLocalizedName).collect(Collectors.joining(", "))).m_130940_(ChatFormatting.GRAY);
            sender.m_288197_(() -> text2, false);
        }
        if (!(tmMoves = pokemon.getForm().getMoves().getAllTMTRHMMoves()).isEmpty()) {
            sender.m_288197_(() -> TextHelper.space(2).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.moves.tmmoves.header", new Object[0])), false);
            text = TextHelper.space(4).m_130946_(tmMoves.stream().map(ITranslatable::getLocalizedName).collect(Collectors.joining(", "))).m_130940_(ChatFormatting.GRAY);
            sender.m_288197_(() -> text, false);
        }
    }
}

