/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategyLoader;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PokemonHelper;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class MainStrategy
extends WikiCommandStrategy {
    public MainStrategy() {
        super("main");
    }

    @Override
    public void execute(CommandSourceStack sender, Pokemon pokemon, String[] args) {
        sender.m_288197_(() -> PixelmonCommandUtils.format("pixelmon.command.wiki.header", PokemonHelper.getFullName(pokemon).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})), false);
        sender.m_288197_(() -> this.wikiPage(pokemon), false);
        sender.m_288197_(() -> this.type(pokemon), false);
        sender.m_288197_(() -> this.abilities(pokemon), false);
        sender.m_288197_(() -> this.catchRate(pokemon), false);
        sender.m_288197_(() -> this.baseStats(pokemon), false);
        sender.m_288197_(() -> this.genderRatio(pokemon), false);
        sender.m_288197_(() -> Component.m_237119_(), false);
        sender.m_288197_(() -> this.getBannerStrategies(sender, pokemon, args), false);
    }

    private MutableComponent getBannerStrategies(CommandSourceStack sender, Pokemon pokemon, String[] args) {
        MutableComponent banners = Component.m_237113_((String)"");
        boolean isFirst = true;
        for (WikiCommandStrategy strategy : WikiCommandStrategyLoader.getStrategiesPrioritized()) {
            Optional<Component> text;
            if (strategy == this || !(text = strategy.getBanner(sender, pokemon, args)).isPresent()) continue;
            if (!isFirst) {
                banners = banners.m_7220_((Component)Component.m_237113_((String)" "));
            }
            banners = banners.m_7220_(text.get());
            isFirst = false;
        }
        return banners;
    }

    private MutableComponent type(Pokemon pokemon) {
        String types = pokemon.getForm().getTypes().stream().map(it -> it.getTranslatedName().getString()).collect(Collectors.joining(", "));
        return PixelmonCommandUtils.format("pixelmon.command.wiki.type", types);
    }

    private MutableComponent wikiPage(Pokemon pokemon) {
        String wikiUrl = "https://pixelmonmod.com/wiki/index.php?title=" + pokemon.getSpecies().getName();
        return PixelmonCommandUtils.format("pixelmon.command.wiki.web", new Object[0]).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.web.wiki", new Object[0]).m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"pixelmon.command.wiki.banner.hover"))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, wikiUrl))));
    }

    private MutableComponent abilities(Pokemon pokemon) {
        MutableComponent abilities = Component.m_237113_((String)"");
        Ability[] regular = pokemon.getForm().getAbilities().getAbilities();
        for (int i = 0; i < regular.length; ++i) {
            boolean isLast;
            abilities.m_7220_((Component)regular[i].getTranslatedName());
            boolean bl = isLast = i == regular.length - 1;
            if (isLast) continue;
            abilities.m_7220_((Component)Component.m_237113_((String)", "));
        }
        Ability[] has = pokemon.getForm().getAbilities().getHiddenAbilities();
        for (int i = 0; i < has.length; ++i) {
            boolean isLast;
            if (i == 0) {
                abilities.m_7220_((Component)Component.m_237113_((String)", "));
            }
            abilities.m_7220_((Component)has[i].getTranslatedName()).m_7220_((Component)Component.m_237115_((String)"pixelmon.command.wiki.ha"));
            boolean bl = isLast = i == has.length - 1;
            if (isLast) continue;
            abilities.m_7220_((Component)Component.m_237113_((String)", "));
        }
        return PixelmonCommandUtils.format("pixelmon.command.wiki.abilities", abilities);
    }

    private MutableComponent catchRate(Pokemon pokemon) {
        return PixelmonCommandUtils.format("pixelmon.command.wiki.catchrate", pokemon.getForm().getCatchRate());
    }

    private MutableComponent baseStats(Pokemon pokemon) {
        return PixelmonCommandUtils.format("pixelmon.command.wiki.basestats", pokemon.getForm().getBattleStats().getStat(BattleStatsType.HP), pokemon.getForm().getBattleStats().getStat(BattleStatsType.ATTACK), pokemon.getForm().getBattleStats().getStat(BattleStatsType.DEFENSE), pokemon.getForm().getBattleStats().getStat(BattleStatsType.SPECIAL_ATTACK), pokemon.getForm().getBattleStats().getStat(BattleStatsType.SPECIAL_DEFENSE), pokemon.getForm().getBattleStats().getStat(BattleStatsType.SPEED));
    }

    private MutableComponent genderRatio(Pokemon pokemon) {
        if (pokemon.getForm().isGenderless()) {
            return PixelmonCommandUtils.format("pixelmon.command.wiki.genderless", new Object[0]);
        }
        String malePercentage = NumberHelper.formatPercentage(pokemon.getForm().getMalePercentage());
        String femalePercentage = NumberHelper.formatPercentage(100.0f - pokemon.getForm().getMalePercentage());
        return PixelmonCommandUtils.format("pixelmon.command.wiki.genderratio", malePercentage, femalePercentage);
    }
}

