/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.util.helpers.PokemonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;

public class FormsPaletteStrategy
extends WikiCommandStrategy {
    public FormsPaletteStrategy() {
        super("formsandpalette", "forms", "palettes");
    }

    @Override
    public int getPriority() {
        return 60;
    }

    @Override
    public Optional<Component> getBanner(CommandSourceStack sender, Pokemon pokemon, String[] args) {
        if (!PokemonHelper.hasPermanentFormsOrPalettes(pokemon)) {
            return Optional.empty();
        }
        return super.getBanner(sender, pokemon, args);
    }

    @Override
    public void execute(CommandSourceStack sender, Pokemon pokemon, String[] args) {
        sender.m_288197_(() -> Component.m_237113_((String)""), false);
        sender.m_288197_(() -> PixelmonCommandUtils.format("pixelmon.command.wiki.formsandpalette.header", PokemonHelper.getFullName(pokemon).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD})), false);
        FormsPaletteStrategy.getUniqueFormPalettes(pokemon).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> sender.m_288197_(() -> (Component)entry.getValue(), false));
    }

    private static Map<String, Component> getUniqueFormPalettes(Pokemon pokemon) {
        HashMap<String, Component> texts = new HashMap<String, Component>();
        for (Stats form : pokemon.getSpecies().getForms()) {
            String name;
            if (FormsPaletteStrategy.shouldDisplayForm(pokemon, form) && !texts.containsKey(name = FormsPaletteStrategy.makeFormString(pokemon, form))) {
                String wiki = "/wiki " + pokemon.getSpecies().getName() + " form:" + form.getName();
                texts.put(name, FormsPaletteStrategy.makeFormPaletteText(name, wiki));
            }
            for (Gender gender : form.getPossibleGenders()) {
                for (PaletteProperties palette : form.getGenderProperties(gender).getPalettes()) {
                    String name2;
                    if (!FormsPaletteStrategy.shouldDisplayPalette(pokemon, palette) || texts.containsKey(name2 = FormsPaletteStrategy.makeFormPaletteString(pokemon, form, palette))) continue;
                    String wiki = "/wiki " + pokemon.getSpecies().getName() + " form:" + form.getName() + " palette:" + palette.getName();
                    texts.put(name2, FormsPaletteStrategy.makeFormPaletteText(name2, wiki));
                }
            }
        }
        return texts;
    }

    private static Component makeFormPaletteText(String name, String wiki) {
        return TextHelper.space(2).m_7220_((Component)Component.m_237113_((String)"- ")).m_7220_((Component)PixelmonCommandUtils.format(name, new Object[0])).m_7220_((Component)TextHelper.space(1)).m_7220_((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237115_((String)"pixelmon.command.wiki.formsandpalette.anchor").m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"pixelmon.command.wiki.formsandpalette.anchor.hover", (Object[])new Object[]{name}))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, wiki)))).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.AQUA)));
    }

    private static String makeFormString(Pokemon pokemon, Stats form) {
        Object formName = "";
        if (FormsPaletteStrategy.shouldDisplayForm(pokemon, form) && !form.isDefault()) {
            formName = Component.m_237115_((String)form.getTranslationKey()).getString() + " ";
        }
        Object palette = "";
        if (!pokemon.isDefaultPalette()) {
            palette = pokemon.getPalette().getLocalizedName() + " ";
        }
        return (String)formName + (String)palette + pokemon.getLocalizedName();
    }

    private static String makeFormPaletteString(Pokemon pokemon, Stats form, PaletteProperties palette) {
        Object formName = "";
        if (FormsPaletteStrategy.shouldDisplayForm(pokemon, form) && !form.isDefault()) {
            formName = Component.m_237115_((String)form.getTranslationKey()).getString() + " ";
        }
        Object paletteName = "";
        if (FormsPaletteStrategy.shouldDisplayPalette(pokemon, palette)) {
            paletteName = Component.m_237115_((String)palette.getTranslationKey()).getString() + " ";
        }
        return (String)formName + (String)paletteName + pokemon.getLocalizedName();
    }

    private static boolean shouldDisplayForm(Pokemon pokemon, Stats form) {
        return !form.isTemporary() && pokemon.getForm() != form && !form.isForm("shiny");
    }

    private static boolean shouldDisplayPalette(Pokemon pokemon, PaletteProperties palette) {
        boolean isDifferentPalette = pokemon.getPalette() != palette;
        boolean isNone = palette.getName().equalsIgnoreCase("none");
        boolean isShiny = palette.getName().equalsIgnoreCase("shiny");
        return isDifferentPalette && !isNone & !isShiny;
    }
}

