/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.item.JsonItemStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.InteractEvolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.api.util.helpers.PokemonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class EvolutionStrategy
extends WikiCommandStrategy {
    public EvolutionStrategy() {
        super("evolution");
    }

    @Override
    public int getPriority() {
        return 90;
    }

    @Override
    public Optional<Component> getBanner(CommandSourceStack sender, Pokemon pokemon, String[] args) {
        if (pokemon.getForm().getEvolutions().isEmpty()) {
            return Optional.empty();
        }
        return super.getBanner(sender, pokemon, args);
    }

    @Override
    public void execute(CommandSourceStack sender, Pokemon pokemon, String[] args) {
        sender.m_288197_(() -> PixelmonCommandUtils.format("pixelmon.command.wiki.evolution.header", PokemonHelper.getFullName(pokemon).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})), false);
        for (Evolution evo : pokemon.getForm().getEvolutions()) {
            if (evo instanceof LevelingEvolution) {
                LevelingEvolution leveling = (LevelingEvolution)evo;
                if (leveling.level == null) {
                    sender.m_288197_(() -> TextHelper.space(1).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.evolution.leveling.nospecification", evo.to.create().getLocalizedName())), false);
                } else {
                    int level = ((LevelingEvolution)evo).level;
                    sender.m_288197_(() -> TextHelper.space(1).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.evolution.leveling", evo.to.create().getLocalizedName(), level)), false);
                }
            } else if (evo instanceof InteractEvolution) {
                JsonItemStack item = ((InteractEvolution)evo).item;
                sender.m_288197_(() -> TextHelper.space(1).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.evolution.interact", evo.to.create().getLocalizedName(), item.getItemStack().m_41786_().getString())), false);
            } else {
                sender.m_288197_(() -> TextHelper.space(1).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.evolution." + evo.evoType, evo.to.create().getLocalizedName())), false);
            }
            if (evo.conditions.isEmpty()) continue;
            sender.m_288197_(() -> TextHelper.space(3).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.evolution.conditions.header", new Object[0])), false);
            for (EvoCondition condition : evo.conditions) {
                MutableComponent text = condition.getDescription();
                if (text == null) continue;
                sender.m_288197_(() -> TextHelper.space(5).m_7220_((Component)text), false);
            }
        }
    }
}

