/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.daycare.DayCareDuration;
import com.pixelmonmod.pixelmon.api.daycare.DayCareRequirement;
import com.pixelmonmod.pixelmon.api.daycare.impl.PixelmonDayCareCondition;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.AbstractRequirement;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.ItemStackRequirement;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.OneTimeFemaleItemStackRequirement;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.PokeDollarsRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.DayCareHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PokemonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class DayCareStrategy
extends WikiCommandStrategy {
    public DayCareStrategy() {
        super("daycare");
    }

    @Override
    public int getPriority() {
        return 80;
    }

    @Override
    public Optional<Component> getBanner(CommandSourceStack sender, Pokemon pokemon, String[] args) {
        if (pokemon.getForm().isGenderless()) {
            return Optional.empty();
        }
        return super.getBanner(sender, pokemon, args);
    }

    @Override
    public void execute(CommandSourceStack sender, Pokemon pokemon, String[] args) {
        sender.m_288197_(() -> PixelmonCommandUtils.format("pixelmon.command.wiki.daycare.header", PokemonHelper.getFullName(pokemon).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})), false);
        String egggroups = pokemon.getForm().getEggGroups().stream().map(ITranslatable::getLocalizedName).collect(Collectors.joining(", "));
        sender.m_288197_(() -> TextHelper.space(1).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.egggroup", egggroups)), false);
        int steps = pokemon.getForm().getEggCycles() * PixelmonConfigProxy.getBreeding().getStepsPerEggCycle();
        sender.m_288197_(() -> TextHelper.space(1).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.eggsteps", DayCareStrategy.format(steps))), false);
        sender.m_288197_(() -> Component.m_237119_(), false);
        List<PixelmonDayCareCondition> conditions = DayCareHelper.getConditions(pokemon);
        for (PixelmonDayCareCondition condition : conditions) {
            if (condition.getDurations().size() == 1) {
                DayCareDuration duration2 = condition.getDurations().get(0);
                sender.m_288197_(() -> TextHelper.space(1).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.daycare.duration.single", duration2.getDisplay().getString())), false);
            } else if (condition.getDurations().size() > 1) {
                sender.m_288197_(() -> TextHelper.space(1).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.daycare.duration.multiple", new Object[0])), false);
                condition.getDurations().stream().sorted(Comparator.comparing(DayCareDuration::getPriority)).forEach(duration -> sender.m_288197_(() -> TextHelper.space(2).m_7220_((Component)Component.m_237113_((String)"- ")).m_130946_(duration.getDisplay().getString()), false));
            }
            if (condition.getRequirements().isEmpty()) continue;
            sender.m_288197_(() -> TextHelper.space(1).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.daycare.requirement", new Object[0])), false);
            for (DayCareRequirement requirement : condition.getRequirements()) {
                if (requirement instanceof ItemStackRequirement) {
                    ItemStackRequirement itemStackRequirement = (ItemStackRequirement)requirement;
                    for (ItemStack item : itemStackRequirement.getRequiredItems()) {
                        sender.m_288197_(() -> TextHelper.space(2).m_7220_((Component)Component.m_237113_((String)"- ")).m_130946_(item.m_41613_() + "x ").m_130946_(item.m_41786_().getString()).m_130938_(s -> s.m_131157_(ChatFormatting.GRAY)), false);
                    }
                    continue;
                }
                if (requirement instanceof PokeDollarsRequirement) {
                    PokeDollarsRequirement dollarsRequirement = (PokeDollarsRequirement)requirement;
                    sender.m_288197_(() -> TextHelper.space(2).m_7220_((Component)Component.m_237113_((String)"- ")).m_7220_((Component)PixelmonCommandUtils.format("pixelmon.command.wiki.daycare.requirement.money", DayCareStrategy.format(dollarsRequirement.getAmount()))).m_130938_(s -> s.m_131157_(ChatFormatting.GRAY)), false);
                    continue;
                }
                if (requirement instanceof OneTimeFemaleItemStackRequirement) {
                    OneTimeFemaleItemStackRequirement oneTimeFemaleItemStackRequirement = (OneTimeFemaleItemStackRequirement)requirement;
                    for (ItemStack item : oneTimeFemaleItemStackRequirement.getRequiredItems()) {
                        sender.m_288197_(() -> TextHelper.space(2).m_7220_((Component)Component.m_237113_((String)"- ")).m_130946_(item.m_41613_() + "x ").m_130946_(item.m_41786_().getString()).m_130946_(" ").m_7220_((Component)TextHelper.translate("pixelmon.command.wiki.daycare.requirement.onetime")).m_130938_(s -> s.m_131157_(ChatFormatting.GRAY)), false);
                    }
                    continue;
                }
                if (!(requirement instanceof AbstractRequirement)) continue;
                AbstractRequirement abstractRequirement = (AbstractRequirement)requirement;
                sender.m_288197_(() -> TextHelper.space(2).m_7220_((Component)Component.m_237113_((String)"- ")).m_7220_(abstractRequirement.getError()).m_130938_(s -> s.m_131157_(ChatFormatting.GRAY)), false);
            }
        }
    }

    private static String format(double amount) {
        NumberFormat format = NumberFormat.getInstance();
        format.setGroupingUsed(true);
        return format.format(amount);
    }
}

