/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.quests;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class SetStageCommand
extends PixelCommand {
    public SetStageCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "setstage", "/setstage <quest> <stage> [player]", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 2)).length != 3) {
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.setstage.invalidargs", new Object[0]);
        }
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(args[2]);
        short stage = (short)PixelmonCommandUtils.requireInt(args[1], Short.MIN_VALUE, Short.MAX_VALUE, "parsing.int.invalid", new Object[0]);
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        QuestData data = party.getQuestData();
        QuestProgress progress = PixelmonCommandUtils.require(data.getProgressForQuest(args[0], true), "pixelmon.command.invalidquest", new Object[0]);
        if (stage == -1) {
            progress.complete(player);
        } else {
            if (!progress.setStage(stage)) {
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.setstage.invalidstage", args[1], args[0].replace("_", " "));
                return;
            }
            progress.reopen();
        }
        progress.sendTo(player);
        String[] finalArgs = args;
        sender.m_288197_(() -> Component.m_237110_((String)"pixelmon.command.setstage.notify", (Object[])new Object[]{sender.m_81368_(), player.m_5446_().getString(), finalArgs[0].replace("_", " "), finalArgs[1]}), true);
        PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.setstage.set", player.m_5446_().getString(), args[0].replace("_", " "), args[1]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) {
        switch (args.length) {
            case 1: {
                return Lists.newArrayList(QuestRegistry.getInstance().getQuestFilepaths(true));
            }
            case 3: {
                if (!this.hasPermissionOtherTarget(sender)) break;
                return PixelmonCommandUtils.tabCompleteUsernames();
            }
        }
        return Collections.emptyList();
    }
}

