/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.quests;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class QuestDataCommand
extends PixelCommand {
    public QuestDataCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "questdata", "/questdata <quest> {numeric,literal} <key> [value]", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length == 3 || args.length == 4) {
            boolean set;
            ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(sender.m_81368_());
            boolean bl = set = args.length == 4;
            if (!args[1].equalsIgnoreCase("literal") && !args[1].equalsIgnoreCase("numeric")) {
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.questdata.invalidargs", new Object[0]);
                return;
            }
            boolean numeric = args[1].equalsIgnoreCase("numeric");
            PlayerPartyStorage party = StorageProxy.getPartyNow(player);
            QuestData data = party.getQuestData();
            QuestProgress progress = PixelmonCommandUtils.require(data.getProgressForQuest(args[0], true), "pixelmon.command.invalidquest", new Object[0]);
            if (set) {
                if (numeric) {
                    progress.setData(args[2], PixelmonCommandUtils.requireInt(args[3], "parsing.int.invalid"));
                } else {
                    progress.setData(args[2], args[3]);
                }
                progress.sendTo(player);
                sender.m_288197_(() -> Component.m_237110_((String)"pixelmon.command.questdata.set.notify", (Object[])new Object[]{sender.m_81368_(), args[1], args[2], args[3], args[0].replace("_", " ")}), true);
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.questdata.set", args[1], args[2], args[3], args[0].replace("_", " "));
            } else {
                Object result = numeric ? progress.getDataLong(args[2]) : progress.getDataString(args[2]);
                sender.m_288197_(() -> Component.m_237110_((String)"pixelmon.command.questdata.get.notify", (Object[])new Object[]{sender.m_81368_(), args[1], args[2], args[0].replace("_", " ")}), true);
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.questdata.get", args[1], args[2], result, args[0].replace("_", " "));
            }
        } else {
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.questdata.invalidargs", new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) {
        switch (args.length) {
            case 1: {
                return Lists.newArrayList(QuestRegistry.getInstance().getQuestFilepaths(true));
            }
            case 2: {
                return Arrays.asList("numeric", "literal");
            }
        }
        return Collections.emptyList();
    }
}

