/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.econ;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class GiveMoneyCommand
extends PixelCommand {
    public GiveMoneyCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "givemoney", "/givemoney [player] <money>", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length == 2) {
            GameProfile target = PixelmonCommandUtils.findProfile(args[0]);
            if (target == null) {
                PixelmonCommandUtils.endCommand("argument.entity.notfound.player", args[0]);
            }
            double amount = NumberHelper.parseDouble(args[1]).orElse(0.0);
            BankAccount targetAccount = PixelmonCommandUtils.require(BankAccountProxy.getBankAccountNow(target.getId()), "pixelmon.command.general.invalidplayer", new Object[0]);
            double beforeCurrency = targetAccount.getBalance().doubleValue();
            if (amount < 0.0) {
                targetAccount.take(Math.abs(amount));
            } else {
                targetAccount.add(amount);
            }
            double currencyDifference = (double)targetAccount.getBalance().intValue() - beforeCurrency;
            if (currencyDifference == 0.0) {
                if (amount > 0.0) {
                    PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.givemoney.moneylimit", target.getName());
                } else {
                    PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "pixelmon.command.givemoney.nomoney", target.getName());
                }
            } else {
                String currencyString = Double.toString(currencyDifference);
                sender.m_288197_(() -> Component.m_237110_((String)"pixelmon.command.givemoney.notifygive", (Object[])new Object[]{sender.m_81368_(), currencyDifference, target.getName()}), true);
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.givemoney.given", currencyString, target.getName());
                ServerPlayer player = PixelmonCommandUtils.getEntityPlayer(target.getId());
                if (player != null && player != sender.m_81373_()) {
                    PixelmonCommandUtils.sendMessage(player, ChatFormatting.GRAY, "pixelmon.command.givemoney.received", sender.m_81357_(), currencyString);
                }
            }
        } else {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

