/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.econ;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class BankTransferCommand
extends PixelCommand {
    public BankTransferCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "transfer", "/transfer <player> <money>", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if (args.length == 2) {
            ServerPlayer target;
            ServerPlayer player = sender.m_81375_();
            if (player == (target = PixelmonCommandUtils.requireEntityPlayer(args[0]))) {
                PixelmonCommandUtils.endCommand("pixelmon.command.transfer.sameplayer", new Object[0]);
            }
            int amount = PixelmonCommandUtils.requireInt(args[1], 1, 999999, "parsing.int.invalid", new Object[0]);
            BankAccount userAccount = BankAccountProxy.getBankAccountNow(player);
            BankAccount targetAccount = BankAccountProxy.getBankAccountNow(target);
            if (userAccount.getBalance().doubleValue() < (double)amount) {
                PixelmonCommandUtils.endCommand("pixelmon.command.transfer.notenoughmoney", new Object[0]);
            }
            int beforeCurrency = targetAccount.getBalance().intValue();
            targetAccount.add(amount);
            int currencyDifference = targetAccount.getBalance().intValue() - beforeCurrency;
            if (currencyDifference == 0) {
                if (amount > 0) {
                    PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.givemoney.moneylimit", target.m_5446_());
                } else {
                    PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.givemoney.nomoney", target.m_5446_());
                }
                targetAccount.setBalance(beforeCurrency);
            } else {
                userAccount.take(currencyDifference);
                String currencyString = Integer.toString(currencyDifference);
                sender.m_288197_(() -> Component.m_237110_((String)"pixelmon.command.transfer.notifytransfer", (Object[])new Object[]{sender.m_81368_(), currencyString, target.m_5446_()}), true);
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.transfer.transferred", currencyString, target.m_5446_());
                target.m_213846_((Component)Component.m_237110_((String)"pixelmon.command.transfer.received", (Object[])new Object[]{player.m_5446_(), currencyString}));
            }
        } else {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) {
        return args.length == 1 ? PixelmonCommandUtils.tabCompleteUsernames() : Collections.emptyList();
    }
}

