/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.blocks.tileentity.WarpPlateTileEntity;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;

public class WarpPlateCommand
extends PixelCommand {
    public WarpPlateCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "warpplate", "/warpplate set x y z", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(sender);
        if (args.length == 4 && args[0].equalsIgnoreCase("set")) {
            Block blockStandingOn = player.f_19853_.m_8055_(player.m_20183_()).m_60734_();
            if (blockStandingOn == PixelmonBlocks.warp_plate) {
                WarpPlateTileEntity warpPlate = (WarpPlateTileEntity)player.f_19853_.m_7702_(player.m_20183_());
                if (warpPlate != null && warpPlate.calculatePosition(args[1], args[2], args[3]) != null) {
                    warpPlate.setWarpPosition(args[1], args[2], args[3]);
                    PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.warpplate.set", warpPlate.getWarpPosition());
                } else {
                    PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, this.getUsage(sender), new Object[0]);
                }
            } else {
                PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "pixelmon.command.warpplate.notstanding", new Object[0]);
            }
        } else {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }
}

