/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.StringUtils;

public class TeachCommand
extends PixelCommand {
    public TeachCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "teach", "/teach [player] <slot> <move>", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        Attack attack;
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length != 3) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        if (BattleRegistry.getBattle((Player)player) != null) {
            PixelmonCommandUtils.endCommand("pixelmon.command.general.inbattle", new Object[0]);
        }
        if (party.guiOpened) {
            PixelmonCommandUtils.endCommand("pixelmon.command.teach.busy", player.m_5446_().getString());
        }
        int slot = PixelmonCommandUtils.requireInt(args[1], 1, 6, "pixelmon.command.slot", 6);
        Pokemon pokemon = PixelmonCommandUtils.require(party.get(slot - 1), "pixelmon.command.teach.nothing", player.m_5446_().getString());
        String attackName = StringUtils.join((Object[])args, (String)" ", (int)2, (int)args.length);
        if (Attack.hasAttack(attackName = attackName.replace('_', ' '))) {
            attack = new Attack(attackName);
        } else {
            try {
                if (!Attack.hasAttack(attackName)) {
                    PixelmonCommandUtils.endCommand("pixelmon.command.teach.nomove", attackName);
                    return;
                }
                attack = new Attack(attackName);
            }
            catch (CommandRuntimeException e) {
                PixelmonCommandUtils.endCommand("pixelmon.command.teach.nomove", attackName);
                return;
            }
        }
        if (attack.getMove().is("g_max", "max")) {
            ChatHandler.sendChat((Entity)player, "pixelmon.interaction.tmcantlearn", pokemon.getLocalizedName(), attack.getMove().getTranslatedName());
            return;
        }
        if (!pokemon.getMoveset().hasAttack(attack)) {
            if (pokemon.getMoveset().size() >= 4) {
                LearnMoveController.sendLearnMove(player, pokemon.getUUID(), attack.getActualMove());
                PixelmonCommandUtils.sendMessage(sender, ChatFormatting.GREEN, "pixelmon.command.teach.sentmove", player.m_5446_().getString(), pokemon.getLocalizedName(), attack.getActualMove().getTranslatedName());
            } else {
                pokemon.getMoveset().add(attack);
                PixelmonCommandUtils.sendMessage(sender, ChatFormatting.GREEN, "pixelmon.stats.learnedmove", pokemon.getLocalizedName(), attack.getActualMove().getTranslatedName());
            }
        } else {
            PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "pixelmon.command.teach.knowsmove", player.m_5446_().getString(), pokemon.getLocalizedName(), attack.getActualMove().getTranslatedName());
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        boolean hasPermissionOtherTarget = this.hasPermissionOtherTarget(sender);
        switch (args.length) {
            case 0: {
                return super.getTabCompletions(server, sender, args, pos);
            }
            case 1: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
            case 2: {
                if (!hasPermissionOtherTarget) break;
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
        }
        ArrayList<String> list = new ArrayList<String>(AttackRegistry.getAllAttackNames());
        list.replaceAll(s -> s.replace(" ", "_"));
        return list;
    }
}

