/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;

public class TMCommand
extends PixelCommand {
    public TMCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "tms", "/tms <pokemon>", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        Optional<Species> s;
        if (args.length != 1) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        if (!(s = PixelmonSpecies.fromNameOrDex(args[0])).isPresent()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.movelist.pokemonnotfound", args[0]);
        }
        Pokemon pokemon = PokemonFactory.create(s.get());
        Set<ImmutableAttack> tmMoves = pokemon.getForm().getMoves().getTMMoves();
        List attackNames = tmMoves.stream().map(ImmutableAttack::getAttackName).collect(Collectors.toList());
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.tm.header", pokemon.getLocalizedName()), false);
        if (tmMoves.isEmpty()) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.tm.none", pokemon.getLocalizedName()), false);
            return;
        }
        ArrayList names = Lists.newArrayList();
        for (ImmutableAttack tmMove : tmMoves) {
            names.add(tmMove.getTranslatedName().getString());
        }
        CommandChatHandler.sendFormattedChat(sender, ChatFormatting.GREEN, String.join((CharSequence)(ChatFormatting.GREEN + ", "), attackNames), new Object[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return PixelmonCommandUtils.tabCompletePokemon();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

