/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.statue.StatueSpecification;
import com.pixelmonmod.api.statue.StatueSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class StatueSpawnCommand
extends PixelCommand {
    public StatueSpawnCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "statuespawn", "/statuespawn <spec>", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length <= 1) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
            return;
        }
        ServerLevel world = sender.m_81372_();
        ParseAttempt<StatueSpecification> parseAttempt = StatueSpecificationProxy.create(args);
        if (!parseAttempt.wasSuccess()) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", parseAttempt.getError()), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
            return;
        }
        StatueEntity statue = PixelmonCommandUtils.require(parseAttempt.get().create((Level)world), "pixelmon.command.general.notingame", args[0]);
        statue.canDespawn = false;
        Entity entity = sender.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            statue.f_20885_ = player.m_146908_();
            statue.m_146922_(statue.f_20885_);
        }
        world.m_7967_((Entity)statue);
        if (statue.m_20182_() == Vec3.f_82478_) {
            statue.m_146884_(sender.m_81371_());
        }
        PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.spawn.spawned", statue.getSpecies().getTranslatedName());
        PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.spawn.spawnednotify", sender.m_81368_(), statue.getSpecies().getTranslatedName());
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) {
        ArrayList all = Lists.newArrayList();
        all.addAll(PixelmonCommandUtils.SPEC_REQUIREMENTS);
        all.addAll(PixelmonSpecies.getFormattedEnglishNameSet());
        return all;
    }
}

