/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpecTestCommand
extends PixelCommand {
    public SpecTestCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "spectest", "/spectest", 2);
    }

    @Override
    public boolean executeCommand(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (!(sender.m_81373_() instanceof ServerPlayer)) {
            sender.m_81352_((Component)TextHelper.translate("pixelmon.command.spectest.failure.not_player"));
            return false;
        }
        if (args.length == 0) {
            sender.m_81352_((Component)TextHelper.translate("pixelmon.command.spectest.failure.no_spec"));
            return false;
        }
        ParseAttempt<PokemonSpecification> parseAttempt = PokemonSpecificationProxy.create(args);
        if (!parseAttempt.wasSuccess()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.general.invalid", parseAttempt.getError());
        }
        PokemonSpecification spec = parseAttempt.get();
        ServerPlayer player = (ServerPlayer)sender.m_81373_();
        Arrow arrow = new Arrow((Level)sender.m_81372_(), (LivingEntity)player);
        arrow.m_20256_(player.m_20154_().m_82490_(10.0));
        arrow.m_20011_(player.m_20191_().m_82400_(1.0));
        HitResult hitResult = SpecTestCommand.getHitResult((Entity)arrow, entity -> !Objects.equals(player, entity));
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            sender.m_81352_((Component)TextHelper.translate("pixelmon.command.spectest.failure.miss"));
            return false;
        }
        EntityHitResult result = (EntityHitResult)hitResult;
        if (result.m_6662_() != HitResult.Type.ENTITY || !(result.m_82443_() instanceof PixelmonEntity)) {
            sender.m_81352_((Component)TextHelper.translate("pixelmon.command.spectest.failure.not_pokemon"));
            return false;
        }
        boolean matches = spec.matches(result.m_82443_());
        if (matches) {
            sender.m_288197_(() -> TextHelper.translate("pixelmon.command.spectest.success"), false);
            return true;
        }
        sender.m_81352_((Component)TextHelper.translate("pixelmon.command.spectest.failure"));
        return false;
    }

    public static HitResult getHitResult(Entity entity, Predicate<Entity> test) {
        EntityHitResult HitResult1;
        Vec3 Vec32;
        Vec3 Vec33 = entity.m_20184_();
        Level world = entity.f_19853_;
        Vec3 Vec31 = entity.m_20182_();
        BlockHitResult hitResult = world.m_45547_(new ClipContext(Vec31, Vec32 = Vec31.m_82549_(Vec33), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            Vec32 = hitResult.m_82450_();
        }
        if ((HitResult1 = ProjectileUtil.m_37304_((Level)world, (Entity)entity, (Vec3)Vec31, (Vec3)Vec32, (AABB)entity.m_20191_().m_82369_(entity.m_20184_()).m_82400_(1.0), test)) != null) {
            hitResult = HitResult1;
        }
        return hitResult;
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Level level, Entity origin, Vec3 position, Vec3 p_221269_3_, AABB p_221269_4_, Predicate<Entity> p_221269_5_) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : level.m_6249_(origin, p_221269_4_, p_221269_5_)) {
            double d1;
            AABB axisalignedbb = entity1.m_20191_();
            Optional optional = axisalignedbb.m_82371_(position, p_221269_3_);
            if (!optional.isPresent() || !((d1 = position.m_82557_((Vec3)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        return PixelmonCommandUtils.tabCompleteUsernames();
    }
}

