/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class SpawningCommand
extends PixelCommand {
    public SpawningCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "spawning", "/spawning {off|on|diagnose]", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length == 0) {
            if (PixelmonSpawning.coordinator != null && PixelmonSpawning.coordinator.getActive()) {
                PixelmonCommandUtils.sendMessage(sender, "Spawner: On.", new Object[0]);
            } else {
                PixelmonCommandUtils.sendMessage(sender, "Spawner: Off", new Object[0]);
            }
        } else if (args[0].equalsIgnoreCase("off")) {
            if (PixelmonSpawning.coordinator != null) {
                PixelmonSpawning.coordinator.deactivate();
            }
            PixelmonCommandUtils.sendMessage(sender, "All spawning has been turned off.", new Object[0]);
        } else if (args[0].equalsIgnoreCase("on")) {
            if (PixelmonSpawning.coordinator != null) {
                PixelmonSpawning.coordinator.deactivate();
            }
            PixelmonSpawning.startTrackingSpawner();
            PixelmonCommandUtils.sendMessage(sender, "Better Spawning system has been engaged.", new Object[0]);
        } else if (args[0].equalsIgnoreCase("diagnose")) {
            boolean spawnerActive = PixelmonSpawning.coordinator != null && PixelmonSpawning.coordinator.getActive();
            PixelmonCommandUtils.sendMessage(sender, ChatFormatting.GRAY + "Better Spawner: " + (spawnerActive ? ChatFormatting.GREEN + "Active." : ChatFormatting.RED + "Inactive."), new Object[0]);
            if (spawnerActive) {
                int spawnerCount = PixelmonSpawning.coordinator.spawners.size();
                PixelmonCommandUtils.sendMessage(sender, ChatFormatting.GRAY + "Spawner count: " + ChatFormatting.YELLOW + spawnerCount, new Object[0]);
                if (spawnerCount > 0) {
                    ArrayList<CallSite> summaryMessages = new ArrayList<CallSite>();
                    for (AbstractSpawner abstractSpawner : PixelmonSpawning.coordinator.spawners) {
                        double expectedSeconds;
                        if (!(abstractSpawner instanceof PlayerTrackingSpawner)) continue;
                        PlayerTrackingSpawner pts = (PlayerTrackingSpawner)abstractSpawner;
                        ServerPlayer player = pts.getTrackedPlayer();
                        String message = player == null ? ChatFormatting.RED + "OFFLINE PLAYER " + ChatFormatting.GRAY + "(" : ChatFormatting.YELLOW + player.m_7755_().getString() + " (";
                        double percentage = (double)pts.spawnedTracker.count() / (double)pts.capacity * 100.0;
                        String strPercentage = String.format("%.1f", percentage) + "%";
                        strPercentage = percentage == 100.0 || percentage == 0.0 ? ChatFormatting.RED + strPercentage : ChatFormatting.YELLOW + strPercentage;
                        message = message + strPercentage + ChatFormatting.GRAY + ") - Last Cycle: ";
                        long timeSinceLastCycle = System.currentTimeMillis() - pts.lastCycleTime;
                        double seconds = (double)timeSinceLastCycle / 1000.0;
                        message = seconds > (expectedSeconds = (double)(pts.spawnFrequency / 60.0f)) * 60.0 ? message + ChatFormatting.RED + String.format("%.1f", seconds) + "s" : (seconds > expectedSeconds * 10.0 ? message + ChatFormatting.YELLOW + String.format("%.1f", seconds) + "s" : message + ChatFormatting.GREEN + String.format("%.1f", seconds) + "s");
                        message = message + ChatFormatting.GRAY + " - Last Spawn: ";
                        long timeSinceLastSpawn = System.currentTimeMillis() - pts.lastSpawnTime;
                        seconds = (double)timeSinceLastSpawn / 1000.0;
                        String time = String.format("%.1f", seconds) + "s";
                        message = seconds > expectedSeconds * 60.0 ? message + ChatFormatting.RED + time : (seconds > expectedSeconds * 10.0 ? message + ChatFormatting.YELLOW + time : message + ChatFormatting.GREEN + time);
                        summaryMessages.add((CallSite)((Object)message));
                    }
                    for (String string : summaryMessages) {
                        sender.m_288197_(() -> Component.m_237113_((String)message), false);
                    }
                }
            }
        } else {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) {
        return args.length == 1 ? Lists.newArrayList((Object[])new String[]{"on", "off", "diagnose"}) : Collections.emptyList();
    }
}

