/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;

public class SetRaidCommand
extends PixelCommand {
    public SetRaidCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "setraid", "/setraid <species> <stars> [x] [y] [z] [world]", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if (args.length == 2 || args.length == 6) {
            DenEntity den;
            Stats form;
            Species species;
            if (args[0].contains(":")) {
                String[] split = args[0].split(":");
                species = PixelmonCommandUtils.require(PixelmonSpecies.fromName(split[0]).getValueUnsafe(), "argument.species.notfound", split[0]);
                form = species.getForm(split[1]);
            } else {
                species = PixelmonCommandUtils.require(PixelmonSpecies.fromName(args[0]).getValueUnsafe(), "argument.species.notfound", args[0]);
                form = null;
            }
            if (form == null) {
                form = species.getDefaultForm();
            }
            int stars = PixelmonCommandUtils.requireInt(args[1], 1, 5, "argument.raidstars.invalid", args[1]);
            if (args.length == 2) {
                ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(sender);
                den = (DenEntity)player.m_9236_().m_45963_(DenEntity.class, TargetingConditions.f_26872_, null, player.m_20185_(), player.m_20186_(), player.m_20189_(), new AABB(player.m_20185_() - 10.0, player.m_20186_() - 10.0, player.m_20189_() - 10.0, player.m_20185_() + 10.0, player.m_20186_() + 10.0, player.m_20189_() + 10.0));
            } else {
                int x = PixelmonCommandUtils.requireInt(args[2], "argument.coordinate.invalid");
                int y = PixelmonCommandUtils.requireInt(args[3], "argument.coordinate.invalid");
                int z = PixelmonCommandUtils.requireInt(args[4], "argument.coordinate.invalid");
                ServerLevel world = (ServerLevel)PixelmonCommandUtils.require(DimensionHelper.getWorld(args[5]), "argument.world.notfound", new Object[]{args[5]});
                den = (DenEntity)world.m_45963_(DenEntity.class, TargetingConditions.f_26872_, null, (double)x, (double)y, (double)z, new AABB((double)(x - 10), (double)(y - 10), (double)(z - 10), (double)(x + 10), (double)(y + 10), (double)(z + 10)));
            }
            if (den != null) {
                den.setData(new RaidData(den.m_19879_(), stars, species, form));
                sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.setraid", species.getName(), stars), false);
                PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.setraid.notify", sender.m_81368_(), den.toString());
            } else {
                sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.setraid.noden", new Object[0]), false);
            }
        } else {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return PixelmonCommandUtils.tabCompletePokemon();
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5"});
        }
        if (args.length == 6) {
            return PixelmonCommandUtils.tabCompleteWorld();
        }
        return Collections.emptyList();
    }
}

