/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChooseMovesetPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChoosingMovesetData;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SetPartyCommand
extends PixelCommand {
    public SetPartyCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "setparty", "/setparty <lvl>", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length == 1 || args.length == 2) {
            int level = PixelmonCommandUtils.requireInt(args[0], 1, PixelmonConfigProxy.getGeneral().getMaxLevel(), "parsing.int.invalid", new Object[0]);
            ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(sender);
            if (BattleRegistry.getBattle((Player)player) != null) {
                PixelmonCommandUtils.endCommand("pixelmon.command.general.inbattle", new Object[0]);
            }
            PlayerPartyStorage party = StorageProxy.getPartyNow(player);
            List<Pokemon> team = party.getTeam();
            team.forEach(p -> p.setLevel(level));
            if (args.length == 2 && args[1].equals("moves")) {
                ChoosingMovesetData data = new ChoosingMovesetData(player, team);
                data.next();
                if (!data.pokemonList.isEmpty()) {
                    ChooseMovesetPacket.choosingMoveset.put(player.m_20148_(), data);
                }
            }
        } else {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return IntStream.range(1, PixelmonConfigProxy.getGeneral().getMaxLevel()).mapToObj(String::valueOf).collect(Collectors.toList());
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

