/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;

public class ReloadMoveAnimations
extends PixelCommand {
    public ReloadMoveAnimations(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length == 0) {
            PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "Missing argument: Move name", new Object[0]);
            return;
        }
        Object moveName = args[0];
        for (int i = 1; i < args.length; ++i) {
            moveName = (String)moveName + " " + args[i];
        }
        File file = new File("pixelmon/moves/" + (String)(moveName = ((String)moveName).replace(".json", "")) + ".json");
        if (!file.exists()) {
            PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "Couldn't find file: \"pixelmon/moves/\" + moveName + \".json\"", new Object[0]);
            return;
        }
        try {
            ImmutableAttack immutableAttack = (ImmutableAttack)AttackRegistry.GSON.fromJson((Reader)new FileReader(file), ImmutableAttack.class);
            if (immutableAttack == null) {
                throw new Exception();
            }
            ImmutableAttack existing = AttackRegistry.getAttackBase(immutableAttack.getAttackName()).get();
            existing.animations = immutableAttack.animations;
            PixelmonCommandUtils.sendMessage(sender, ChatFormatting.DARK_GREEN, "Reloaded animations for move: " + immutableAttack.getTranslatedName(), new Object[0]);
            return;
        }
        catch (Exception e) {
            PixelmonCommandUtils.sendMessage(sender, "There was a problem in the JSON", new Object[0]);
            e.printStackTrace();
            return;
        }
    }

    @Override
    public String getName() {
        return "reloadmoveanimations";
    }

    @Override
    public String getUsage(CommandSourceStack sender) {
        return "/reloadmoveanimations <move name>";
    }

    @Override
    public List<String> getAliases() {
        return Arrays.asList("reloadmoveanimation");
    }
}

