/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.enums.items.EnumFossils;
import com.pixelmonmod.pixelmon.items.CoveredFossilItem;
import com.pixelmonmod.pixelmon.items.FossilItem;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.eventbus.api.Event;

public class RedeemFossilCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"restorefossil", "fossil"});

    public RedeemFossilCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "redeemfossil", "/redeemfossil [all]", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        Item itemInOffHand;
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(sender);
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (held.m_41619_() || held.m_41720_().equals(Items.f_41852_)) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
            return;
        }
        ItemStack heldOffHand = player.m_21120_(InteractionHand.OFF_HAND);
        Item itemInHand = held.m_41720_();
        Species species = this.getFossilSpecies(sender, itemInHand, itemInOffHand = heldOffHand.m_41720_());
        if (species == null) {
            return;
        }
        boolean isGen8Fossil = species.getGeneration() == 8;
        int decreaseCount = 1;
        if (args.length > 0 && args[0].equalsIgnoreCase("all")) {
            decreaseCount = isGen8Fossil ? Math.min(held.m_41613_(), heldOffHand.m_41613_()) : held.m_41613_();
        }
        int finalDecreaseCount = decreaseCount;
        PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
        PixelmonCommandUtils.THREAD_POOL.submit(() -> {
            for (int i = 0; i < finalDecreaseCount; ++i) {
                Pokemon pokemon = PokemonFactory.create(species);
                pokemon.setLevel(1);
                pokemon.setBall(PokeBallRegistry.POKE_BALL.getValueUnsafe());
                pps.add(pokemon);
                Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent(player, pokemon, "Fossil"));
            }
        });
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.redeemfossil.recoveredall", held.m_41613_(), species.getLocalizedName()), false);
        held.m_41774_(decreaseCount);
        if (isGen8Fossil) {
            heldOffHand.m_41774_(decreaseCount);
        }
    }

    private Species getFossilSpecies(CommandSourceStack sender, Item itemInHand, Item itemInOffHand) {
        if (itemInHand instanceof FossilItem) {
            FossilItem fossil = (FossilItem)itemInHand;
            if (fossil.getFossil().getGeneration() == 8) {
                if (itemInOffHand instanceof FossilItem) {
                    FossilItem fossil2 = (FossilItem)itemInOffHand;
                    return this.getGen8FossilSpecies(fossil.getFossil(), fossil2.getFossil());
                }
                sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.redeemfossil.emptyoffhand", new Object[0]), false);
                return null;
            }
            return fossil.getFossil().getPokemon();
        }
        if (itemInHand instanceof CoveredFossilItem) {
            CoveredFossilItem fossil = (CoveredFossilItem)itemInHand;
            if (fossil.getFossil().getGeneration() == 8) {
                if (itemInOffHand instanceof CoveredFossilItem) {
                    CoveredFossilItem fossil2 = (CoveredFossilItem)itemInOffHand;
                    return this.getGen8FossilSpecies(fossil.getFossil(), fossil2.getFossil());
                }
                sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.redeemfossil.emptyoffhand", new Object[0]), false);
                return null;
            }
            return fossil.getFossil().getPokemon();
        }
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.redeemfossil.notfossil", new Object[0]), false);
        return null;
    }

    private Species getGen8FossilSpecies(EnumFossils fossil1, EnumFossils fossil2) {
        if (fossil1.equals((Object)EnumFossils.BIRD) && fossil2.equals((Object)EnumFossils.DRAKE) || fossil1.equals((Object)EnumFossils.DRAKE) && fossil2.equals((Object)EnumFossils.BIRD)) {
            return PixelmonSpecies.DRACOZOLT.getValueUnsafe();
        }
        if (fossil1.equals((Object)EnumFossils.BIRD) && fossil2.equals((Object)EnumFossils.DINO) || fossil1.equals((Object)EnumFossils.DINO) && fossil2.equals((Object)EnumFossils.BIRD)) {
            return PixelmonSpecies.ARCTOZOLT.getValueUnsafe();
        }
        if (fossil1.equals((Object)EnumFossils.FISH) && fossil2.equals((Object)EnumFossils.DRAKE) || fossil1.equals((Object)EnumFossils.DRAKE) && fossil2.equals((Object)EnumFossils.FISH)) {
            return PixelmonSpecies.DRACOVISH.getValueUnsafe();
        }
        if (fossil1.equals((Object)EnumFossils.FISH) && fossil2.equals((Object)EnumFossils.DINO) || fossil1.equals((Object)EnumFossils.DINO) && fossil2.equals((Object)EnumFossils.FISH)) {
            return PixelmonSpecies.ARCTOVISH.getValueUnsafe();
        }
        return null;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, @Nullable BlockPos targetPos) throws CommandSyntaxException {
        if (args.length <= 1) {
            return Collections.singletonList("all");
        }
        return super.getTabCompletions(server, sender, args, targetPos);
    }
}

