/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class PokeTestCommand
extends PixelCommand {
    public PokeTestCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "poketest", "/poketest [player] <slot> <specs...>", 2);
    }

    @Override
    public boolean executeCommand(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        PokemonSpecification spec;
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 3) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayer target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        int slot = PixelmonCommandUtils.requireInt(args[1], 1, 6, "pixelmon.command.pokeedit.slot", new Object[0]);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(slot - 1), "pixelmon.command.partyslot.nothing", target.m_7755_());
        CharSequence[] specList = Arrays.copyOfRange(args, 2, args.length);
        ParseAttempt<PokemonSpecification> parseAttempt = PokemonSpecificationProxy.create(String.join((CharSequence)" ", specList));
        if (!parseAttempt.wasSuccess()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.general.invalid", parseAttempt.getError());
        }
        if ((spec = parseAttempt.get()).matches(pokemon)) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.poketest.match", pokemon.getLocalizedName()), false);
            return true;
        }
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.poketest.nomatch", pokemon.getLocalizedName()), false);
        return false;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        boolean hasPermissionOtherTarget = this.hasPermissionOtherTarget(sender);
        switch (args.length) {
            case 0: {
                return super.getTabCompletions(server, sender, args, pos);
            }
            case 1: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
            case 2: {
                if (!hasPermissionOtherTarget) break;
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
        }
        return PixelmonCommandUtils.SPEC_REQUIREMENTS;
    }
}

