/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class PokeSpawnCommand
extends PixelCommand {
    public PokeSpawnCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "pokespawn", "/pokespawn <pokemon> [<x> <y> <z>]", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length >= 1) {
            BlockPos pos;
            ServerLevel world = sender.m_81372_();
            ParseAttempt<PokemonSpecification> parseAttempt = PokemonSpecificationProxy.create(args);
            if (!parseAttempt.wasSuccess()) {
                sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", parseAttempt.getError()), false);
                PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
                return;
            }
            PixelmonEntity pokemon = PixelmonCommandUtils.require(parseAttempt.get().create((Level)world), "pixelmon.command.general.notingame", args[0]);
            if (args.length >= 4) {
                try {
                    pos = new BlockPos(Integer.parseInt(args[1]), Integer.parseInt(args[2]), Integer.parseInt(args[3]));
                }
                catch (NumberFormatException e) {
                    pos = new BlockPos((int)sender.m_81371_().m_7096_(), (int)sender.m_81371_().m_7098_(), (int)sender.m_81371_().m_7094_());
                }
            } else {
                pos = new BlockPos((int)sender.m_81371_().m_7096_(), (int)sender.m_81371_().m_7098_(), (int)sender.m_81371_().m_7094_());
            }
            pokemon.m_6034_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
            pokemon.canDespawn = false;
            pokemon.setSpawnLocation(pokemon.getDefaultSpawnLocation());
            world.m_7967_((Entity)pokemon);
            pokemon.resetAI();
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.spawn.spawned", pokemon.getSpecies().getTranslatedName());
            PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.spawn.spawnednotify", sender.m_81368_(), pokemon.getSpecies().getTranslatedName());
        } else {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) {
        ArrayList all = Lists.newArrayList();
        all.addAll(PixelmonCommandUtils.SPEC_REQUIREMENTS);
        all.addAll(PixelmonSpecies.getFormattedEnglishNameSet());
        return all;
    }
}

