/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.CommandHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class PokeSeeCommand
extends PixelCommand {
    public PokeSeeCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "pokesee", "/pokesee [player]", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        args = this.setupTargetOrSourceAsTarget(sender, args, 0);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(StorageProxy.getPartyNow(this.findUuid(sender, args[0])), "pixelmon.command.general.invalidplayer", new Object[0]);
        Pokemon[] party = storage.getAll();
        String[] finalArgs = args;
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.AQUA, "pixelmon.command.pokesee.header", finalArgs[0]), false);
        for (Pokemon pokemon : party) {
            if (pokemon == null) {
                sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.pokesee.empty", new Object[0]), false);
                continue;
            }
            if (pokemon.isEgg()) {
                sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.pokesee.egg", new Object[0]), false);
                continue;
            }
            sender.m_288197_(() -> CommandHelper.getHoverTextPokemon(pokemon, new int[0]), false);
        }
    }

    private UUID findUuid(CommandSourceStack sender, String username) throws CommandSyntaxException {
        if (PixelmonConfigProxy.getCommands().isPokeseeAllowOfflineCheck()) {
            GameProfile profile = PixelmonCommandUtils.require(PixelmonCommandUtils.findProfile(username), "pixelmon.command.general.invalidplayer", new Object[0]);
            return profile.getId();
        }
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(username);
        if (PlayerHelper.hasPermission(player, "pixelmon.pokesee.exempt") && !PlayerHelper.hasPermission(sender.m_81375_(), "pixelmon.pokesee.exempt")) {
            throw PixelmonCommandUtils.getException("pixelmon.command.pokesee.exempt", username);
        }
        return player.m_20148_();
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

