/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public class PokeKillCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"pkill"});

    public PokeKillCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "pokekill", "/pokekill <specs...>", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        ParseAttempt<PokemonSpecification> parseAttempt;
        ServerLevel world = PixelmonCommandUtils.getWorld(args, sender);
        ParseAttempt<PokemonSpecification> parseAttempt2 = parseAttempt = args.length == 0 ? null : PokemonSpecificationProxy.create(args);
        if (parseAttempt != null && !parseAttempt.wasSuccess()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.general.invalid", parseAttempt.getError());
        }
        PokemonSpecification spec = parseAttempt == null ? null : parseAttempt.get();
        int count = 0;
        for (Entity entity : world.m_142646_().m_142273_()) {
            PixelmonEntity pixelmon;
            if (!(entity instanceof PixelmonEntity) || (pixelmon = (PixelmonEntity)entity).hasOwner() || pixelmon.battleController != null || spec != null && !spec.matches((Object)pixelmon)) continue;
            pixelmon.m_6074_();
            ++count;
        }
        int finalCount = count;
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.pokekill.success", finalCount), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length <= 1) {
            return PixelmonCommandUtils.SPEC_REQUIREMENTS;
        }
        return Collections.emptyList();
    }
}

