/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PokeGiveCommand
extends PixelCommand {
    public PokeGiveCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "pokegive", "/pokegive [player] <spec...>", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if (args.length >= 1) {
            PokedexEvent.Pre preEvent;
            ParseAttempt<PokemonSpecification> parse;
            GameProfile profile = PixelmonSpecies.has((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0))[0].toLowerCase(Locale.ROOT)) && ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(args[0]) == null ? PixelmonCommandUtils.requireEntityPlayer(sender).m_36316_() : PixelmonCommandUtils.findProfile(args[0]);
            if (profile == null) {
                PixelmonCommandUtils.endCommand("argument.entity.notfound.player", args[0]);
            }
            ServerPlayer player = PixelmonCommandUtils.getEntityPlayer(profile.getId());
            PlayerPartyStorage pps = StorageProxy.getPartyNow(profile.getId());
            if (profile.getName().equalsIgnoreCase(args[0])) {
                args = Arrays.copyOfRange(args, 1, args.length);
            }
            if (!(parse = PokemonSpecificationProxy.create(args)).wasSuccess()) {
                PixelmonCommandUtils.endCommand("pixelmon.command.general.invalid", parse.getError());
            }
            Pokemon pokemon = parse.get().create();
            if (player != null && Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent(player, pokemon, "Command"))) {
                return;
            }
            if (player != null && BattleRegistry.getBattle((Player)player) != null) {
                StorageProxy.getPCForPlayerNow(profile.getId()).add(pokemon);
            } else {
                StorageProxy.getPartyNow(profile.getId()).add(pokemon);
            }
            if (!pokemon.isEgg() && !Pixelmon.EVENT_BUS.post((Event)(preEvent = new PokedexEvent.Pre(pps.uuid, pokemon, PokedexRegistrationStatus.CAUGHT, "commandGiven")))) {
                pps.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
                pps.playerPokedex.update();
                Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(player.m_20148_(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
            }
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.give.givesuccess" + (pokemon.isEgg() ? "egg" : ""), profile.getName(), pokemon.getSpecies().getTranslatedName());
            PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.give.notifygive" + (pokemon.isEgg() ? "egg" : ""), sender.m_81368_(), profile.getName(), pokemon.getSpecies().getTranslatedName());
        } else {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        List<String> pokemon = PixelmonCommandUtils.tabCompletePokemon();
        switch (args.length) {
            case 0: {
                return super.getTabCompletions(server, sender, args, pos);
            }
            case 1: {
                if (this.hasPermissionOtherTarget(sender)) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                pokemon.add("random");
                return pokemon;
            }
            case 2: {
                pokemon.add("random");
                return pokemon;
            }
        }
        return PixelmonCommandUtils.SPEC_REQUIREMENTS;
    }
}

