/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class PokeDelCommand
extends PixelCommand {
    private static final List<String> PC_PARTY_SUGGESTION = Lists.newArrayList((Object[])new String[]{"party", "pc"});

    public PokeDelCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "pokedel", "Invalid usage! Usages:\n/pokedel [player] party <slot>\n/pokedel [player] party <spec...>\n/pokedel [player] pc <box> <slot>\n/pokedel [player] pc <box> <spec...>\n/pokedel [player] pc <spec...>", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        boolean isParty;
        if ((args = this.setupTargetOrSourceAsTarget(sender, args, 0)).length < 3) {
            PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, this.getUsage(sender), new Object[0]);
            return;
        }
        ServerPlayer target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        if (!args[1].equalsIgnoreCase("party") && !args[1].equalsIgnoreCase("pc")) {
            PixelmonCommandUtils.endCommand("pixelmon.command.pokedel.invalidstorage", new Object[0]);
        }
        if (isParty = args[1].equalsIgnoreCase("party")) {
            this.partyDelete(sender, target, args);
        } else {
            this.compDelete(sender, target, args);
        }
    }

    private void partyDelete(CommandSourceStack sender, ServerPlayer target, String[] args) {
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        storage.retrieveAll("Command");
        if (storage.countAll() == 1) {
            sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.pokedel.lastpokemon", target.m_5446_().getString()));
            return;
        }
        OptionalInt slotOptional = NumberHelper.parseInt(args[2]);
        if (slotOptional.isPresent()) {
            if (!PixelmonCommandUtils.PARTY_SLOTS.contains(args[2])) {
                sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.invalidslot", target.m_5446_().getString()));
                return;
            }
            Pokemon pokemon = PixelmonCommandUtils.require(storage.get(slotOptional.getAsInt() - 1), "pixelmon.command.partyslot.nothing", target.m_7755_().getString());
            storage.set(pokemon.getPosition(), null);
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.pokedel.success", target.m_5446_().getString(), pokemon.getLocalizedName()), false);
        } else {
            String[] specList = Arrays.copyOfRange(args, 2, args.length);
            PokemonSpecification spec = PokemonSpecificationProxy.create(specList).get();
            for (Pokemon pokemon : storage.getTeam()) {
                if (pokemon == null || !spec.matches(pokemon)) continue;
                if (storage.countAll() == 1) {
                    sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.pokedel.lastpokemon", target.m_5446_().getString(), pokemon.getLocalizedName()));
                    break;
                }
                storage.set(pokemon.getPosition(), null);
                sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.pokedel.success", target.m_5446_().getString(), pokemon.getLocalizedName()), false);
            }
        }
    }

    private void compDelete(CommandSourceStack sender, ServerPlayer target, String[] args) {
        PCStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getComputerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        storage.retrieveAll("Command");
        OptionalInt boxOptional = NumberHelper.parseInt(args[2]);
        if (boxOptional.isPresent()) {
            int box = boxOptional.getAsInt();
            OptionalInt slotOptional = NumberHelper.parseInt(args[3]);
            if (slotOptional.isPresent()) {
                int slot = slotOptional.getAsInt();
                Pokemon pokemon = PixelmonCommandUtils.require(storage.get(box - 1, slot - 1), "pixelmon.command.compslot.nothing", target.m_7755_().getString());
                storage.set(box - 1, slot - 1, null);
                sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.pokedel.success", target.m_5446_().getString(), pokemon.getDisplayName()), false);
            } else {
                String[] specList = Arrays.copyOfRange(args, 3, args.length);
                PokemonSpecification spec = PokemonSpecificationProxy.create(specList).get();
                for (Pokemon pokemon : storage.getBox(box - 1).getAll()) {
                    this.checkAndDeleteFromPC(sender, target, storage, spec, pokemon);
                }
            }
        } else {
            String[] specList = Arrays.copyOfRange(args, 2, args.length);
            PokemonSpecification spec = PokemonSpecificationProxy.create(specList).get();
            for (Pokemon pokemon : storage.getAll()) {
                this.checkAndDeleteFromPC(sender, target, storage, spec, pokemon);
            }
        }
    }

    private void checkAndDeleteFromPC(CommandSourceStack sender, ServerPlayer target, PCStorage storage, PokemonSpecification spec, Pokemon pokemon) {
        if (pokemon == null || !spec.matches(pokemon) || pokemon.getPosition() == null) {
            return;
        }
        storage.set(pokemon.getPosition(), null);
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.pokedel.success", target.m_5446_().getString(), pokemon.getLocalizedName()), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        boolean hasPermissionOtherTarget = this.hasPermissionOtherTarget(sender);
        switch (args.length) {
            case 0: {
                return super.getTabCompletions(server, sender, args, pos);
            }
            case 1: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return PC_PARTY_SUGGESTION;
            }
            case 2: {
                if (!hasPermissionOtherTarget) break;
                return PC_PARTY_SUGGESTION;
            }
        }
        ArrayList suggestions = Lists.newArrayList((Object[])PokemonSpecificationProxy.getRequirementNames());
        suggestions.addAll(PixelmonCommandUtils.PARTY_SLOTS);
        return suggestions;
    }
}

