/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public class PokeBombCommand
extends PixelCommand {
    public PokeBombCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "pokebomb", "/pokebomb <specs...>", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length == 0) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerLevel world = sender.m_81372_();
        ParseAttempt<PokemonSpecification> parseAttempt = PokemonSpecificationProxy.create(args);
        if (!parseAttempt.wasSuccess()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.general.invalid", parseAttempt.getError());
        }
        PokemonSpecification spec = parseAttempt.get();
        for (Entity entity : world.m_142646_().m_142273_()) {
            PixelmonEntity pixelmon;
            if (!(entity instanceof PixelmonEntity) || (pixelmon = (PixelmonEntity)entity).hasOwner() || pixelmon.battleController != null) continue;
            spec.apply((Object)pixelmon);
            pixelmon.getPokemon().initialize(new InitializeCategory[0]);
            pixelmon.resetAI();
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length >= 1) {
            return PixelmonCommandUtils.SPEC_REQUIREMENTS;
        }
        return Collections.emptyList();
    }
}

