/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ClientChangeOpenPCPacket;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PcCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"pokepc", "ppc"});

    public PcCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "pc", "/pc [boxnumber]", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(sender);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
        if (storage.guiOpened) {
            PixelmonCommandUtils.endCommand("pixelmon.command.pc.busy", new Object[0]);
        }
        PCStorage pc = PixelmonCommandUtils.require(PixelmonCommandUtils.getComputerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
        if (args.length > 0) {
            int box = PixelmonCommandUtils.requireInt(args[0], 1, pc.getBoxCount(), "pixelmon.command.box", pc.getBoxCount());
            pc.setLastBox(box - 1);
        }
        NetworkHelper.sendPacket(new ClientChangeOpenPCPacket(pc.uuid), player);
        OpenScreenPacket.open((Player)player, EnumGuiScreen.PC, new int[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return IntStream.range(1, 100).mapToObj(String::valueOf).toList();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

