/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public class NpcKillCommand
extends PixelCommand {
    public NpcKillCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "npckill", "/npckill <world> <type>", 2);
    }

    @Override
    public List<String> getAliases() {
        return Lists.newArrayList((Object[])new String[]{"npkill"});
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        ServerLevel world = PixelmonCommandUtils.getWorld(args, sender);
        int count = 0;
        int trainersInBattle = 0;
        for (Entity entity : world.m_142646_().m_142273_()) {
            if (!(entity instanceof NPCEntity)) continue;
            NPCEntity npc = (NPCEntity)entity;
            if (npc instanceof NPCTrainer) {
                NPCTrainer trainer = (NPCTrainer)npc;
                if (trainer.battleController != null) {
                    ++trainersInBattle;
                    continue;
                }
            }
            npc.m_142687_(Entity.RemovalReason.DISCARDED);
            ++count;
        }
        int finalCount = count;
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.npckill.success", finalCount), false);
        if (trainersInBattle > 0) {
            int finalTrainersInBattle = trainersInBattle;
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GRAY, "pixelmon.command.npckill.trainers", finalTrainersInBattle), false);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return Lists.newArrayList((Object[])new String[]{"Overworld", "Nether", "End"});
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{"All", "Chatting", "Doctor", "Relearner", "Shop", "Trader", "Trainer", "Tutor"});
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

