/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import java.util.List;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class MegaRingCommand
extends PixelCommand {
    public MegaRingCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "megaring", "/megaring [player]", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0))[0]);
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        if (!party.getMegaItemsUnlocked().canMega()) {
            party.setMegaItem(EnumMegaItem.BraceletORAS, false);
            party.unlockMega(false);
            if (sender.m_81373_() != player) {
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.megaring.success", player.m_7755_());
            }
            PixelmonCommandUtils.sendMessage(player, "pixelmon.command.megaring.received", new Object[0]);
            PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.megaring.notify", sender.m_81368_(), player.m_7755_());
        } else {
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.megaring.alreadyhas", player.m_7755_());
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

