/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class LevellingCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"plevelling", "level", "plevel"});
    private static final List<String> STATUS = Lists.newArrayList((Object[])new String[]{"off", "on"});

    public LevellingCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "levelling", "/levelling [player] <slot> <on|off>", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length != 3) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
        int slot = PixelmonCommandUtils.requireInt(args[1], 1, 6, "pixelmon.command.levelling.slot", new Object[0]);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(slot - 1), "pixelmon.command.partyslot.nothing", player.m_7755_());
        boolean isLevelling = args[2].equalsIgnoreCase("on");
        if (pokemon == null || pokemon.isEgg()) {
            player.m_213846_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.levelling.failed", new Object[0]));
            return;
        }
        pokemon.setDoesLevel(isLevelling);
        player.m_213846_((Component)PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.levelling.success", isLevelling ? "Enabled" : "Disabled", pokemon.getLocalizedName()));
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        switch (args.length) {
            case 1: {
                if (this.hasPermissionOtherTarget(sender)) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
            case 2: {
                if (this.hasPermissionOtherTarget(sender)) {
                    return PixelmonCommandUtils.PARTY_SLOTS;
                }
                return STATUS;
            }
            case 3: {
                return STATUS;
            }
        }
        return super.getTabCompletions(server, sender, args, pos);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }
}

