/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class IvsCommand
extends PixelCommand {
    public IvsCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "ivs", "/ivs <slot>", 0);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        int slot;
        ServerPlayer player;
        PlayerPartyStorage storage;
        Pokemon pokemon;
        if (args.length < 1) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        if ((pokemon = PixelmonCommandUtils.require((storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(player = PixelmonCommandUtils.requireEntityPlayer(sender)), "pixelmon.command.general.invalidplayer", new Object[0])).get((slot = PixelmonCommandUtils.requireInt(args[0], 1, 6, "pixelmon.command.invalidslot", args[0])) - 1), "pixelmon.command.partyslot.nothing", player.m_7755_().getString())).isEgg() && !PixelmonConfigProxy.getCommands().isCheckEggIVs()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.ivs.checkegg.disabled", new Object[0]);
        }
        sender.m_288197_(() -> ChatHandler.getMessage("pixelmon.command.ivs.header", pokemon.isEgg() ? Component.m_237115_((String)"pixelmon.egg").getString() : pokemon.getLocalizedName()), false);
        for (BattleStatsType type : BattleStatsType.getEVIVStatValues()) {
            boolean isHyperTrained = pokemon.getIVs().isHyperTrained(type);
            String key = isHyperTrained ? "pixelmon.command.ivs.ht" : "pixelmon.command.ivs.noht";
            sender.m_288197_(() -> ChatHandler.getMessage(key, type.getLocalizedName(), pokemon.getIVs().getStat(type)), false);
        }
        int total = pokemon.getIVs().getTotal();
        sender.m_288197_(() -> ChatHandler.getMessage("pixelmon.command.ivs.total", total, total * 100 / 186), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return PixelmonCommandUtils.PARTY_SLOTS;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

