/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class HealCommand
extends PixelCommand {
    public HealCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "pokeheal", "/pokeheal [player...]", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if (args.length > 1) {
            for (String player : args) {
                this.execute(sender, new String[]{player});
            }
        } else {
            ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0))[0]);
            if (BattleRegistry.getBattle((Player)player) != null) {
                PixelmonCommandUtils.endCommand("pixelmon.command.heal.cantheal", player.m_5446_().getString());
            }
            PlayerPartyStorage party = StorageProxy.getPartyNow(player);
            party.heal();
            PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.heal.notifyhealed", sender.m_81368_(), player.m_5446_().getString());
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.heal.healed", player.m_5446_().getString());
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (this.hasPermissionOtherTarget(sender) && args.length >= 1) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

