/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class GivePixelSpriteCommand
extends PixelCommand {
    public GivePixelSpriteCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "givepixelsprite", "/givepixelsprite [player] <spec...>", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 2) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PokemonSpecification spec = PokemonSpecificationProxy.create(args = Arrays.copyOfRange(args, 1, args.length)).get();
        if (!spec.getValue(SpeciesRequirement.class).isPresent()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.general.invalid", new Object[0]);
        }
        ItemStack stack = SpriteItemHelper.getPhoto(spec.create());
        player.m_150109_().m_36054_(stack);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            if (this.hasPermissionOtherTarget(sender)) {
                return PixelmonCommandUtils.tabCompleteUsernames();
            }
            return PixelmonCommandUtils.tabCompletePokemon();
        }
        if (args.length == 2) {
            if (this.hasPermissionOtherTarget(sender)) {
                return PixelmonCommandUtils.tabCompletePokemon();
            }
            return PixelmonCommandUtils.SPEC_REQUIREMENTS;
        }
        if (args.length == 3) {
            return PixelmonCommandUtils.SPEC_REQUIREMENTS;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

