/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.events.PokegiftEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.Event;

public class GiftCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"psell", "pokegift", "pgift", "gift"});

    public GiftCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "pokesell", "/pokesell <player> <slot>", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length < 2) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        if (!(sender.m_81373_() instanceof ServerPlayer)) {
            sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.playercommand", new Object[0]));
            return;
        }
        ServerPlayer self = PixelmonCommandUtils.requireEntityPlayer(sender);
        PlayerPartyStorage selfStorage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(self), "pixelmon.command.general.invalidplayer", new Object[0]);
        if (self.m_7755_().getString().equals(args[0])) {
            sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.gift.toself", new Object[0]));
            return;
        }
        ServerPlayer target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage targetStorage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        int slot = PixelmonCommandUtils.requireInt(args[1], 1, 6, "pixelmon.command.invalidslot", args[1]);
        Pokemon pokemon = PixelmonCommandUtils.require(selfStorage.get(slot - 1), "pixelmon.command.partyslot.nothing", self.m_7755_().getString());
        if (pokemon.hasFlag("untradeable")) {
            sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.gift.untradeable", new Object[0]));
            return;
        }
        if (selfStorage.getTeam().size() == 1 && !pokemon.isEgg()) {
            sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.gift.partyspace", new Object[0]));
            return;
        }
        if (selfStorage.inTemporaryMode()) {
            sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.gift.selftemporarymode", new Object[0]));
            return;
        }
        if (targetStorage.inTemporaryMode()) {
            sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.gift.targettemporarymode", new Object[0]));
            return;
        }
        selfStorage.retrieveAll("Command");
        if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent(target, pokemon, "GiftCommand"))) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokegiftEvent(self, target, pokemon))) {
            return;
        }
        selfStorage.set(slot - 1, null);
        targetStorage.add(pokemon);
        target.m_213846_((Component)PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.gift.received", self.m_7755_().getString(), pokemon.getTranslatedName().getString()));
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.gift.gifted", target.m_7755_().getString(), pokemon.getTranslatedName().getString()), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        if (args.length == 2) {
            return PixelmonCommandUtils.PARTY_SLOTS;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

