/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;

public class GenerateStorageTestFileCommand
extends PixelCommand {
    public GenerateStorageTestFileCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "generatestoragetest", "/generatestoragetest", 4);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        ServerPlayer player = sender.m_81375_();
        PCStorage pc = new PCStorage(player.m_20148_(), 512);
        for (Species species : PixelmonSpecies.getAll()) {
            for (Stats form : species.getForms()) {
                for (Gender genderProperty : form.getPossibleGenders()) {
                    for (PaletteProperties palette : form.getGenderProperties(genderProperty).getPalettes()) {
                        pc.add(PokemonBuilder.builder().species(species).form(form).gender(form.isGenderless() ? Gender.NONE : genderProperty).palette(palette.getName()).build());
                    }
                }
            }
        }
        PartyStorage party = new PartyStorage(player.m_20148_());
        for (int i = 0; i < 6; ++i) {
            party.add(PokemonSpecificationProxy.create("random").get().create());
        }
        StorageProxy.getSaveScheduler().save(pc);
        StorageProxy.getSaveScheduler().save(party);
    }
}

