/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.enums.EnumBerryFlavor;
import com.pixelmonmod.pixelmon.enums.EnumCurryRating;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class FillCurryDexCommand
extends PixelCommand {
    public static final List<String> RATINGS = Lists.newArrayList((Object[])new String[]{"-1", "0", "1", "2", "3", "4", "5"});
    public static final List<String> PAGES = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27"});
    public static final List<String> FLAVORS = Lists.newArrayList((Object[])new String[]{EnumBerryFlavor.SPICY.getLocalizedName(), EnumBerryFlavor.DRY.getLocalizedName(), EnumBerryFlavor.SWEET.getLocalizedName(), EnumBerryFlavor.BITTER.getLocalizedName(), EnumBerryFlavor.SOUR.getLocalizedName(), EnumBerryFlavor.NONE.getLocalizedName()});

    public FillCurryDexCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "fillcurrydex", "/fillcurrydex [player] [rating] [page] [flavor]", 4);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 2) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayer target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = StorageProxy.getPartyNow(target);
        int curryDexRating = this.parseCurryDexRating(args);
        int curryDexPage = this.parseCurryDexPage(args);
        int curryDexFlavor = this.parseCurryDexFlavor(args);
        String curryDexRatingName = curryDexRating >= 0 ? EnumCurryRating.ratingFromOrdinal(curryDexRating).getLocalizedName() : "Unearned";
        String curryDexFlavorName = EnumBerryFlavor.berryFromOrdinal(curryDexFlavor).getLocalizedName();
        ChatFormatting curryDexFlavorColor = this.formatCurryFlavorColor(curryDexFlavor);
        ChatFormatting curryDexRatingColor = this.formatCurryRatingColor(curryDexRating);
        if (curryDexRating == -10) {
            storage.fillEntireCurryDex(EnumCurryRating.CHARIZARD.ordinal());
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.YELLOW, "pixelmon.command.fillcurrydex.complete", target.m_7755_()), false);
        } else if (curryDexPage == -10) {
            if (curryDexRating > 4 || curryDexRating < -2) {
                sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.invalidslot", curryDexRating));
                return;
            }
            storage.fillEntireCurryDex(curryDexRating);
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GRAY, "pixelmon.command.fillcurrydex.entire", target.m_7755_(), curryDexRatingColor + curryDexRatingName), false);
        } else if (curryDexFlavor == -10) {
            if (curryDexPage > 24 || curryDexPage < 0) {
                sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.invalidslot", curryDexPage + 1));
                return;
            }
            storage.fillOneCurryDexPage(curryDexPage, curryDexRating);
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GRAY, "pixelmon.command.fillcurrydex.page", curryDexPage + 1, target.m_7755_(), curryDexRatingColor + curryDexRatingName), false);
        } else {
            if (curryDexFlavor > 5 || curryDexFlavor < 0) {
                sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.invalidslot", curryDexFlavor + 1));
                return;
            }
            storage.fillOneCurryDexFlavor(curryDexPage, curryDexFlavor, curryDexRating);
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GRAY, "pixelmon.command.fillcurrydex.flavor", curryDexFlavorColor + curryDexFlavorName, curryDexPage + 1, target.m_7755_(), curryDexRatingColor + curryDexRatingName), false);
        }
    }

    private int parseCurryDexRating(String ... args) {
        if (args.length < 2) {
            return -10;
        }
        return NumberHelper.parseInt(args[1]).orElse(5) - 1;
    }

    private int parseCurryDexPage(String ... args) {
        if (args.length < 3) {
            return -10;
        }
        return NumberHelper.parseInt(args[2]).orElse(0) - 1;
    }

    private int parseCurryDexFlavor(String ... args) {
        if (args.length < 4) {
            return -10;
        }
        return EnumBerryFlavor.getOrdinalFromBerry(args[3]);
    }

    public ChatFormatting formatCurryFlavorColor(int curryDexFlavor) {
        switch (curryDexFlavor) {
            default: {
                return ChatFormatting.WHITE;
            }
            case 0: {
                return ChatFormatting.GOLD;
            }
            case 1: {
                return ChatFormatting.BLUE;
            }
            case 2: {
                return ChatFormatting.RED;
            }
            case 3: {
                return ChatFormatting.GREEN;
            }
            case 4: {
                return ChatFormatting.YELLOW;
            }
            case 5: 
        }
        return ChatFormatting.GRAY;
    }

    public ChatFormatting formatCurryRatingColor(int curryDexRating) {
        switch (curryDexRating) {
            case 0: {
                return ChatFormatting.LIGHT_PURPLE;
            }
            case 1: {
                return ChatFormatting.DARK_AQUA;
            }
            case 2: {
                return ChatFormatting.GOLD;
            }
            case 3: {
                return ChatFormatting.GRAY;
            }
            default: {
                return ChatFormatting.YELLOW;
            }
            case -2: 
            case -1: 
            case 5: 
        }
        return ChatFormatting.DARK_GRAY;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        if (args.length == 2) {
            return RATINGS;
        }
        if (args.length == 3) {
            return PAGES;
        }
        if (args.length == 4) {
            return FLAVORS;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

