/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class FaintCommand
extends PixelCommand {
    public FaintCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "pokefaint", "/pokefaint [player]", 0);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 1) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
        if (BattleRegistry.getBattle((Player)player) != null) {
            sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.faint.inbattle", args[0]));
            return;
        }
        for (Pokemon pokemon : storage.getTeam()) {
            if (pokemon == null) continue;
            pokemon.setHealth(0);
        }
        String[] finalArgs = args;
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.faint.success", finalArgs[0]), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

