/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ExpCharmCommand
extends PixelCommand {
    public ExpCharmCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "expcharm", "/expcharm [player]", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if (args.length <= 2) {
            args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0);
            ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
            PlayerPartyStorage party = PixelmonCommandUtils.getPlayerStorage(player);
            EnumFeatureState newState = args.length == 2 && args[1].equalsIgnoreCase("remove") ? EnumFeatureState.Disabled : EnumFeatureState.Active;
            party.setExpCharm(newState);
            if (sender.m_81373_() != player) {
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.expcharm.success", player.m_7755_());
            }
            if (newState.equals((Object)EnumFeatureState.Active)) {
                PixelmonCommandUtils.sendMessage(player, "pixelmon.command.expcharm.received", new Object[0]);
                PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.expcharm.notify.received", sender.m_81368_(), player.m_7755_());
            } else {
                PixelmonCommandUtils.sendMessage(player, "pixelmon.command.expcharm.removed", new Object[0]);
                PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.expcharm.notify.removed", sender.m_81368_(), player.m_7755_());
            }
        } else {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        if (args.length <= 2) {
            return PixelmonCommandUtils.REMOVE_ARGUMENT;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

