/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class EvsCommand
extends PixelCommand {
    public EvsCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "evs", "/evs <slot>", 0);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length < 1) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(sender);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
        int slot = PixelmonCommandUtils.requireInt(args[0], 1, 6, "pixelmon.command.invalidslot", args[0]);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(slot - 1), "pixelmon.command.partyslot.nothing", player.m_7755_().getString());
        if (pokemon.isEgg()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.hypertrained.egg", new Object[0]);
        }
        sender.m_288197_(() -> ChatHandler.getMessage("pixelmon.command.evs.header", pokemon.getLocalizedName()), false);
        for (BattleStatsType type : BattleStatsType.getEVIVStatValues()) {
            sender.m_288197_(() -> ChatHandler.getMessage("pixelmon.command.evs.stat", type.getLocalizedName(), pokemon.getEVs().getStat(type)), false);
        }
        int total = pokemon.getEVs().getTotal();
        sender.m_288197_(() -> ChatHandler.getMessage("pixelmon.command.evs.total", "" + total, "" + total * 100 / 510), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return PixelmonCommandUtils.PARTY_SLOTS;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

