/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EndSpectatePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ExitBattlePacket;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class EndBattleCommand
extends PixelCommand {
    public EndBattleCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "endbattle", "/endbattle [player]", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0))[0]);
        BattleController bc = BattleRegistry.getBattle((Player)player);
        if (bc != null) {
            if (bc.removeSpectator(player)) {
                NetworkHelper.sendPacket(new EndSpectatePacket(), player);
            } else {
                bc.endBattle(BattleEndCause.FORCE);
                sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.endbattle.endbattle", new Object[0]), false);
                BattleRegistry.deRegisterBattle(bc);
            }
        } else {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.endbattle.notinbattle", player.m_7755_()), false);
            NetworkHelper.sendPacket(new ExitBattlePacket(), player);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

