/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokemon.species.Pokedex;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;

public class DexCheckCommand
extends PixelCommand {
    public DexCheckCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "dexcheck", "/dexcheck", 0);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(sender);
        PlayerPokedex dex = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage((ServerPlayer)player), (String)"pixelmon.command.general.invalidplayer", (Object[])new Object[0]).playerPokedex;
        int caught = dex.countCaught();
        BigDecimal percent = BigDecimal.valueOf(caught).divide(BigDecimal.valueOf(Pokedex.pokedexSize), new MathContext(5, RoundingMode.HALF_EVEN)).multiply(BigDecimal.valueOf(100L));
        String percentString = NumberHelper.formatPercentage(percent.doubleValue());
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.dexcheck", "" + ChatFormatting.DARK_AQUA + caught + ChatFormatting.GOLD, "" + ChatFormatting.DARK_AQUA + Pokedex.pokedexSize + ChatFormatting.GOLD, ChatFormatting.DARK_AQUA + percentString + ChatFormatting.GOLD), false);
    }
}

